/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PublicKeyCredentialParameters
implements Serializable {
    private final PublicKeyCredentialType type;
    private final COSEAlgorithmIdentifier alg;

    @JsonCreator
    public PublicKeyCredentialParameters(@JsonProperty(value="type") @NonNull PublicKeyCredentialType type, @JsonProperty(value="alg") @NonNull COSEAlgorithmIdentifier alg) {
        AssertUtil.notNull((Object)type, (String)"type must not be null");
        AssertUtil.notNull((Object)alg, (String)"alg must not be null");
        this.type = type;
        this.alg = alg;
    }

    public @NonNull PublicKeyCredentialType getType() {
        return this.type;
    }

    public @NonNull COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialParameters that = (PublicKeyCredentialParameters)o;
        return this.type == that.type && this.alg == that.alg;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.alg);
    }
}

