/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum ClientDataType {
    CREATE("webauthn.create"),
    GET("webauthn.get");

    private final String value;

    private ClientDataType(String value) {
        this.value = value;
    }

    public static @Nullable ClientDataType create(@Nullable String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "webauthn.create": {
                return CREATE;
            }
            case "webauthn.get": {
                return GET;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @Nullable ClientDataType deserialize(@Nullable String value) throws InvalidFormatException {
        try {
            return ClientDataType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, ClientDataType.class);
        }
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }
}

