/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum UserVerificationRequirement {
    REQUIRED("required"),
    PREFERRED("preferred"),
    DISCOURAGED("discouraged");

    private final String value;

    private UserVerificationRequirement(String value) {
        this.value = value;
    }

    public static UserVerificationRequirement create(@NonNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "required": {
                return REQUIRED;
            }
            case "preferred": {
                return PREFERRED;
            }
            case "discouraged": {
                return DISCOURAGED;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull UserVerificationRequirement deserialize(String value) throws InvalidFormatException {
        try {
            return UserVerificationRequirement.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, UserVerificationRequirement.class);
        }
    }

    @JsonValue
    public @NonNull String getValue() {
        return this.value;
    }
}

