/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.KeyProtectionType;

public enum MatcherProtectionType {
    SOFTWARE(1),
    TEE(2),
    ON_CHIP(4);

    private final int value;

    private MatcherProtectionType(int value) {
        this.value = value;
    }

    public static MatcherProtectionType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException("value '" + value + "' is out of range");
        }
        switch (value) {
            case 1: {
                return SOFTWARE;
            }
            case 2: {
                return TEE;
            }
            case 4: {
                return ON_CHIP;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static MatcherProtectionType deserialize(int value) throws InvalidFormatException {
        try {
            return MatcherProtectionType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, KeyProtectionType.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

