/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreAuthenticationParameters;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.CoreRegistrationParameters;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Set;

class BeanAssertUtil {
    private static final String CHALLENGE_MUST_NOT_BE_NULL = "challenge must not be null";

    private BeanAssertUtil() {
    }

    public static void validate(RegistrationData registrationData) {
        BeanAssertUtil.validate((CoreRegistrationData)registrationData);
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(registrationData.getClientExtensions());
        BeanAssertUtil.validate(registrationData.getCollectedClientData());
    }

    public static void validate(CoreRegistrationData registrationData) {
        if (registrationData == null) {
            throw new ConstraintViolationException("registrationData must not be null");
        }
        BeanAssertUtil.validate(registrationData.getAttestationObject());
        if (registrationData.getAttestationObjectBytes() == null) {
            throw new ConstraintViolationException("attestationObjectBytes must not be null");
        }
        if (registrationData.getClientDataHash() == null) {
            throw new ConstraintViolationException("clientDataHash must not be null");
        }
    }

    public static void validate(RegistrationParameters registrationParameters) {
        BeanAssertUtil.validate((CoreRegistrationParameters)registrationParameters);
        BeanAssertUtil.validate(registrationParameters.getServerProperty());
    }

    public static void validate(CoreRegistrationParameters registrationParameters) {
        if (registrationParameters == null) {
            throw new ConstraintViolationException("registrationParameters must not be null");
        }
        BeanAssertUtil.validate(registrationParameters.getServerProperty());
    }

    public static void validate(AuthenticationData authenticationData) {
        BeanAssertUtil.validate((CoreAuthenticationData)authenticationData);
        if (authenticationData.getCollectedClientData() == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        BeanAssertUtil.validate(authenticationData.getCollectedClientData());
        if (authenticationData.getCollectedClientDataBytes() == null) {
            throw new ConstraintViolationException("collectedClientDataBytes must not be null");
        }
        BeanAssertUtil.validateAuthenticationExtensionsClientOutputs(authenticationData.getClientExtensions());
    }

    public static void validate(CoreAuthenticationData authenticationData) {
        if (authenticationData == null) {
            throw new ConstraintViolationException("authenticationData must not be null");
        }
        if (authenticationData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        if (authenticationData.getSignature() == null) {
            throw new ConstraintViolationException("signature must not be null");
        }
        BeanAssertUtil.validate(authenticationData.getAuthenticatorData());
        if (authenticationData.getAuthenticatorDataBytes() == null) {
            throw new ConstraintViolationException("authenticatorDataBytes must not be null");
        }
    }

    public static void validate(AuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate((CoreAuthenticationParameters)authenticationParameters);
        BeanAssertUtil.validate(authenticationParameters.getServerProperty());
    }

    public static void validate(CoreAuthenticationParameters authenticationParameters) {
        if (authenticationParameters == null) {
            throw new ConstraintViolationException("authenticationParameters must not be null");
        }
        if (authenticationParameters.getAuthenticator() == null) {
            throw new ConstraintViolationException("authenticator must not be null");
        }
        BeanAssertUtil.validate(authenticationParameters.getServerProperty());
    }

    public static void validate(CollectedClientData collectedClientData) {
        if (collectedClientData == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        if (collectedClientData.getType() == null) {
            throw new ConstraintViolationException("type must not be null");
        }
        if (collectedClientData.getChallenge() == null) {
            throw new ConstraintViolationException(CHALLENGE_MUST_NOT_BE_NULL);
        }
        if (collectedClientData.getOrigin() == null) {
            throw new ConstraintViolationException("origin must not be null");
        }
        BeanAssertUtil.validate(collectedClientData.getTokenBinding());
    }

    public static void validate(TokenBinding tokenBinding) {
        if (tokenBinding == null) {
            return;
        }
        if (tokenBinding.getStatus() == null) {
            throw new ConstraintViolationException("status must not be null");
        }
    }

    public static void validate(AttestationObject attestationObject) {
        if (attestationObject == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        BeanAssertUtil.validate(attestationObject.getAttestationStatement());
        BeanAssertUtil.validate(attestationObject.getAuthenticatorData());
    }

    public static <T extends ExtensionAuthenticatorOutput> void validate(AuthenticatorData<T> authenticatorData) {
        byte[] rpIdHash;
        if (authenticatorData == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        AttestedCredentialData attestedCredentialData = authenticatorData.getAttestedCredentialData();
        if (attestedCredentialData != null) {
            BeanAssertUtil.validate(attestedCredentialData);
        }
        if ((rpIdHash = authenticatorData.getRpIdHash()) == null) {
            throw new ConstraintViolationException("rpIdHash must not be null");
        }
        if (rpIdHash.length != 32) {
            throw new ConstraintViolationException("rpIdHash must be 32 bytes length");
        }
        long signCount = authenticatorData.getSignCount();
        if (signCount < 0L || signCount > 0xFFFFFFFFL) {
            throw new ConstraintViolationException("signCount must be unsigned int");
        }
        AuthenticationExtensionsAuthenticatorOutputs<T> extensions = authenticatorData.getExtensions();
        BeanAssertUtil.validateAuthenticatorExtensionsOutputs(extensions);
    }

    public static void validate(AttestedCredentialData attestedCredentialData) {
        if (attestedCredentialData == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null");
        }
        AAGUID aaguid = attestedCredentialData.getAaguid();
        if (aaguid == null) {
            throw new ConstraintViolationException("aaguid must not be null");
        }
        if (attestedCredentialData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        COSEKey coseKey = attestedCredentialData.getCOSEKey();
        BeanAssertUtil.validate(coseKey);
    }

    public static <T extends ExtensionClientOutput> void validateAuthenticationExtensionsClientOutputs(AuthenticationExtensionsClientOutputs<T> authenticationExtensionsClientOutputs) {
        if (authenticationExtensionsClientOutputs == null) {
            return;
        }
        for (ExtensionClientOutput value : authenticationExtensionsClientOutputs.getExtensions().values()) {
            value.validate();
        }
    }

    public static <T extends ExtensionAuthenticatorOutput> void validateAuthenticatorExtensionsOutputs(AuthenticationExtensionsAuthenticatorOutputs<T> authenticationExtensionsAuthenticatorOutputs) {
        if (authenticationExtensionsAuthenticatorOutputs == null) {
            return;
        }
        for (ExtensionAuthenticatorOutput value : authenticationExtensionsAuthenticatorOutputs.getExtensions().values()) {
            value.validate();
        }
    }

    public static void validate(ServerProperty serverProperty) {
        BeanAssertUtil.validate((CoreServerProperty)serverProperty);
        Set<Origin> origins = serverProperty.getOrigins();
        if (origins == null || origins.isEmpty()) {
            throw new ConstraintViolationException("origins must not be null or empty");
        }
    }

    public static void validate(CoreServerProperty serverProperty) {
        if (serverProperty == null) {
            throw new ConstraintViolationException("serverProperty must not be null");
        }
        if (serverProperty.getRpId() == null) {
            throw new ConstraintViolationException("rpId must not be null");
        }
        if (serverProperty.getChallenge() == null) {
            throw new ConstraintViolationException(CHALLENGE_MUST_NOT_BE_NULL);
        }
    }

    public static void validate(AttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new ConstraintViolationException("attestationStatement must not be null");
        }
        attestationStatement.validate();
    }

    public static void validate(COSEKey coseKey) {
        if (coseKey == null) {
            throw new ConstraintViolationException("coseKey must not be null");
        }
        coseKey.validate();
    }
}

