/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCOSEKey
implements COSEKey {
    @JsonProperty(value="2")
    private byte[] keyId;
    @JsonProperty(value="3")
    private COSEAlgorithmIdentifier algorithm;
    @JsonProperty(value="4")
    private List<COSEKeyOperation> keyOps;
    @JsonProperty(value="5")
    private byte[] baseIV;

    @JsonCreator
    AbstractCOSEKey(@JsonProperty(value="2") byte[] keyId, @JsonProperty(value="3") COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") List<COSEKeyOperation> keyOps, @JsonProperty(value="5") byte[] baseIV) {
        this.keyId = keyId;
        this.algorithm = algorithm;
        this.keyOps = keyOps;
        this.baseIV = baseIV;
    }

    @Override
    @JsonProperty(value="1")
    public abstract COSEKeyType getKeyType();

    @Override
    public byte[] getKeyId() {
        return ArrayUtil.clone((byte[])this.keyId);
    }

    @Override
    public COSEAlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public List<COSEKeyOperation> getKeyOps() {
        return this.keyOps;
    }

    @Override
    public byte[] getBaseIV() {
        return ArrayUtil.clone((byte[])this.baseIV);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCOSEKey that = (AbstractCOSEKey)o;
        return Arrays.equals(this.keyId, that.keyId) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.keyOps, that.keyOps) && Arrays.equals(this.baseIV, that.baseIV);
    }

    public int hashCode() {
        int result = Objects.hash(this.algorithm, this.keyOps);
        result = 31 * result + Arrays.hashCode(this.keyId);
        result = 31 * result + Arrays.hashCode(this.baseIV);
        return result;
    }
}

