/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientInputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.ExtensionClientOutputDeserializer;
import com.webauthn4j.converter.jackson.deserializer.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.client.AuthenticatorSelectionExtensionClientOutput;
import com.webauthn4j.data.extension.client.BiometricAuthenticatorPerformanceBoundsExtensionClientOutput;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientOutput;
import com.webauthn4j.data.extension.client.GenericTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.data.extension.client.LocationExtensionClientOutput;
import com.webauthn4j.data.extension.client.SimpleTransactionAuthorizationExtensionClientOutput;
import com.webauthn4j.data.extension.client.SupportedExtensionsExtensionClientInput;
import com.webauthn4j.data.extension.client.SupportedExtensionsExtensionClientOutput;
import com.webauthn4j.data.extension.client.UserVerificationIndexExtensionClientOutput;
import com.webauthn4j.data.jws.JWS;
import java.security.cert.X509Certificate;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(ExtensionClientInput.class, (JsonDeserializer)new ExtensionClientInputDeserializer());
        this.addDeserializer(ExtensionClientOutput.class, (JsonDeserializer)new ExtensionClientOutputDeserializer());
        this.addDeserializer(JWS.class, (JsonDeserializer)new JWSDeserializer(objectConverter));
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addSerializer(Challenge.class, (JsonSerializer)new ChallengeSerializer());
        this.addSerializer(JWS.class, (JsonSerializer)new JWSSerializer());
        this.addSerializer(X509Certificate.class, (JsonSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientInput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientInput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(AuthenticatorSelectionExtensionClientOutput.class, "authnSel")});
        this.registerSubtypes(new NamedType[]{new NamedType(BiometricAuthenticatorPerformanceBoundsExtensionClientOutput.class, "biometricPerfBounds")});
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOAppIDExtensionClientOutput.class, "appid")});
        this.registerSubtypes(new NamedType[]{new NamedType(GenericTransactionAuthorizationExtensionClientOutput.class, "txAuthGeneric")});
        this.registerSubtypes(new NamedType[]{new NamedType(LocationExtensionClientOutput.class, "loc")});
        this.registerSubtypes(new NamedType[]{new NamedType(SimpleTransactionAuthorizationExtensionClientOutput.class, "txAuthSimple")});
        this.registerSubtypes(new NamedType[]{new NamedType(SupportedExtensionsExtensionClientOutput.class, "exts")});
        this.registerSubtypes(new NamedType[]{new NamedType(UserVerificationIndexExtensionClientOutput.class, "uvi")});
    }
}

