/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class PublicKeyCredentialDescriptor
implements Serializable {
    private PublicKeyCredentialType type;
    private byte[] id;
    private Set<AuthenticatorTransport> transports;

    public PublicKeyCredentialDescriptor(PublicKeyCredentialType type, byte[] id, Set<AuthenticatorTransport> transports) {
        this.type = type;
        this.id = id;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public PublicKeyCredentialType getType() {
        return this.type;
    }

    public byte[] getId() {
        return (byte[])this.id.clone();
    }

    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredentialDescriptor that = (PublicKeyCredentialDescriptor)o;
        return this.type == that.type && Arrays.equals(this.id, that.id) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.transports);
        result = 31 * result + Arrays.hashCode(this.id);
        return result;
    }
}

