/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.async.verifier;

import com.webauthn4j.async.verifier.attestation.statement.AttestationStatementAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessAsyncVerifier;
import com.webauthn4j.async.verifier.attestation.trustworthiness.self.SelfAttestationTrustworthinessAsyncVerifier;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CompletionStageUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.exception.BadAaguidException;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;

class AttestationAsyncVerifier {
    private static final AAGUID U2F_AAGUID = AAGUID.ZERO;
    private final List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers;
    private final CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier;
    private final SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier;

    AttestationAsyncVerifier(@NotNull List<AttestationStatementAsyncVerifier> attestationStatementAsyncVerifiers, @NotNull CertPathTrustworthinessAsyncVerifier certPathTrustworthinessAsyncVerifier, @NotNull SelfAttestationTrustworthinessAsyncVerifier selfAttestationTrustworthinessAsyncVerifier) {
        AssertUtil.notNull(attestationStatementAsyncVerifiers, (String)"attestationStatementAsyncVerifiers must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessAsyncVerifier, (String)"certPathTrustworthinessAsyncVerifier must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessAsyncVerifier, (String)"selfAttestationTrustworthinessAsyncVerifier must not be null");
        this.attestationStatementAsyncVerifiers = attestationStatementAsyncVerifiers;
        this.certPathTrustworthinessAsyncVerifier = certPathTrustworthinessAsyncVerifier;
        this.selfAttestationTrustworthinessAsyncVerifier = selfAttestationTrustworthinessAsyncVerifier;
    }

    public CompletionStage<Void> verify(@NotNull CoreRegistrationObject registrationObject) {
        return CompletionStageUtil.compose(() -> {
            AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
            return this.verifyAttestationStatement(registrationObject);
        }).thenCompose(attestationType -> {
            AttestationObject attestationObject = registrationObject.getAttestationObject();
            this.verifyAAGUID(attestationObject);
            AttestationStatement attestationStatement = attestationObject.getAttestationStatement();
            switch (attestationType) {
                case SELF: {
                    if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                        CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                        return this.selfAttestationTrustworthinessAsyncVerifier.verify(certificateBaseAttestationStatement);
                    }
                    throw new IllegalStateException();
                }
                case BASIC: 
                case ATT_CA: {
                    if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                        CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                        AAGUID aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid();
                        return this.certPathTrustworthinessAsyncVerifier.verify(aaguid, certificateBaseAttestationStatement, registrationObject.getTimestamp());
                    }
                    throw new IllegalStateException();
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    void verifyAAGUID(@NotNull AttestationObject attestationObject) {
        AAGUID aaguid;
        if (attestationObject.getFormat().equals("fido-u2f") && !Objects.equals(aaguid = attestationObject.getAuthenticatorData().getAttestedCredentialData().getAaguid(), U2F_AAGUID)) {
            throw new BadAaguidException("AAGUID is expected to be zero filled in U2F attestation, but it isn't.");
        }
    }

    @NotNull
    private CompletionStage<AttestationType> verifyAttestationStatement(@NotNull CoreRegistrationObject registrationObject) {
        return CompletionStageUtil.compose(() -> {
            for (AttestationStatementAsyncVerifier verifier : this.attestationStatementAsyncVerifiers) {
                if (!verifier.supports(registrationObject)) continue;
                return verifier.verify(registrationObject);
            }
            throw new BadAttestationStatementException(String.format("AttestationAsyncVerifier is not configured to handle the supplied AttestationStatement format '%s'.", registrationObject.getAttestationObject().getFormat()));
        });
    }
}

