/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.flow.execution.entrance.restful;

import com.webank.wedatasphere.dss.flow.execution.entrance.dao.TaskMapper;
import com.webank.wedatasphere.dss.flow.execution.entrance.entity.WorkflowQueryTask;
import com.webank.wedatasphere.dss.flow.execution.entrance.enums.ExecuteStrategyEnum;
import com.webank.wedatasphere.dss.flow.execution.entrance.service.WorkflowExecutionInfoService;
import com.webank.wedatasphere.dss.standard.app.sso.Workspace;
import com.webank.wedatasphere.dss.standard.sso.utils.SSOHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.log.LogUtils;
import org.apache.linkis.entrance.EntranceServer;
import org.apache.linkis.entrance.annotation.EntranceServerBeanAnnotation;
import org.apache.linkis.entrance.execute.EntranceJob;
import org.apache.linkis.entrance.restful.EntranceRestfulApi;
import org.apache.linkis.entrance.utils.JobHistoryHelper;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.protocol.utils.ZuulEntranceUtils;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.queue.Job;
import org.apache.linkis.scheduler.queue.SchedulerEventState;
import org.apache.linkis.server.BDPJettyServerHelper;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.security.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import scala.Option;

@RequestMapping(path={"/dss/flow/entrance"})
@RestController
public class FlowEntranceRestfulApi
extends EntranceRestfulApi {
    private EntranceServer entranceServer;
    private static final Logger logger = LoggerFactory.getLogger(FlowEntranceRestfulApi.class);
    @Autowired
    private WorkflowExecutionInfoService workflowExecutionInfoService;
    @Autowired
    private TaskMapper taskMapper;

    @EntranceServerBeanAnnotation.EntranceServerAutowiredAnnotation
    public void setEntranceServer(EntranceServer entranceServer) {
        super.setEntranceServer(entranceServer);
        this.entranceServer = entranceServer;
    }

    @RequestMapping(value={"/execute"}, method={RequestMethod.POST})
    public Message execute(HttpServletRequest req, @RequestBody Map<String, Object> json) {
        Message message = null;
        logger.info("Begin to get an execID");
        Workspace workspace = SSOHelper.getWorkspace((HttpServletRequest)req);
        String umUser = SecurityFilter.getLoginUsername((HttpServletRequest)req);
        json.put("umUser", umUser);
        json.put("executeUser", umUser);
        Map params = (Map)json.get("params");
        if (json.containsKey(ExecuteStrategyEnum.IS_RE_EXECUTE.getName())) {
            params.put("executeStrategy", ExecuteStrategyEnum.IS_RE_EXECUTE.getValue());
            try {
                String flowIdStr = ((Map)BDPJettyServerHelper.jacksonJson().readValue(json.get("executionCode").toString(), Map.class)).get("flowId").toString();
                String succeedJobIdsStr = this.workflowExecutionInfoService.getSucceedJobsByFlowId(Long.parseLong(flowIdStr));
                if (StringUtils.isNotEmpty((String)succeedJobIdsStr)) {
                    params.put("nodeID", succeedJobIdsStr);
                }
            }
            catch (Exception e) {
                logger.error("re execute job failed:", (Throwable)e);
            }
        } else if (json.containsKey(ExecuteStrategyEnum.IS_SELECTED_EXECUTE.getName())) {
            params.put("executeStrategy", ExecuteStrategyEnum.IS_SELECTED_EXECUTE.getValue());
            String nodeID = Optional.ofNullable(json.get("nodeID").toString()).orElseThrow(() -> {
                logger.error("execute selected node failed because nodeID is empty");
                return new NullPointerException();
            });
            params.put("nodeID", nodeID);
        } else {
            params.put("executeStrategy", ExecuteStrategyEnum.IS_EXECUTE.getValue());
        }
        params.put("workspace", workspace);
        String label = ((Map)json.get("labels")).get("route").toString();
        params.put("labels", label);
        String execID = this.entranceServer.execute(json);
        Job job = (Job)this.entranceServer.getJob(execID).get();
        JobRequest task = ((EntranceJob)job).getJobRequest();
        Long taskID = task.getId();
        this.pushLog(LogUtils.generateInfo((String)"You have submitted a new job, script code (after variable substitution) is"), job);
        this.pushLog("************************************SCRIPT CODE************************************", job);
        this.pushLog(task.getExecutionCode(), job);
        this.pushLog("************************************SCRIPT CODE************************************", job);
        this.pushLog(LogUtils.generateInfo((String)("Your job is accepted,  jobID is " + execID + " and taskID is " + taskID + ". Please wait it to be scheduled")), job);
        execID = ZuulEntranceUtils.generateExecID((String)execID, (String)Sender.getThisServiceInstance().getApplicationName(), (String[])new String[]{Sender.getThisInstance()});
        message = Message.ok();
        message.setMethod("/api/entrance/execute");
        message.data("execID", (Object)execID);
        message.data("taskID", (Object)taskID);
        logger.info("End to get an an execID: {}, taskID: {}", (Object)execID, (Object)taskID);
        return message;
    }

    @RequestMapping(value={"/{id}/status"}, method={RequestMethod.GET})
    public Message status(@PathVariable(value="id") String id, @RequestParam(required=false, name="taskID") String taskID) {
        Option job;
        Message message = null;
        String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception e) {
            logger.warn("\u83b7\u53d6\u4efb\u52a1 {} \u72b6\u6001\u65f6\u51fa\u73b0\u9519\u8bef", (Object)realId, (Object)e);
            long realTaskID = Long.parseLong(taskID);
            WorkflowQueryTask queryTask = new WorkflowQueryTask();
            queryTask.setTaskID(realTaskID);
            List<WorkflowQueryTask> taskList = this.taskMapper.selectTask(queryTask);
            message = Message.ok();
            if (null == taskList || taskList.size() != 1) {
                int size = 0;
                if (null != taskList) {
                    size = taskList.size();
                }
                logger.error("Got {} task for taskID : {}", (Object)size, (Object)realTaskID);
                message = Message.error((String)("Got " + size + " task for taskId : " + realTaskID));
            } else {
                String status = taskList.get(0).getStatus();
                message.data("status", (Object)status).data("execID", (Object)id);
            }
            message.setMethod("/api/entrance/" + id + "/status");
            return message;
        }
        if (job.isDefined()) {
            message = Message.ok();
            message.setMethod("/api/entrance/" + id + "/status");
            message.data("status", (Object)((Job)job.get()).getState().toString()).data("execID", (Object)id);
        } else {
            message = Message.error((String)"ID The corresponding job is empty and cannot obtain the corresponding task status.(ID \u5bf9\u5e94\u7684job\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u83b7\u53d6\u76f8\u5e94\u7684\u4efb\u52a1\u72b6\u6001)");
        }
        return message;
    }

    @RequestMapping(path={"/{id}/kill"}, method={RequestMethod.GET})
    public Message kill(@PathVariable(value="id") String id, @RequestParam(value="taskID", required=false) Long taskID) {
        Message message;
        Option job;
        String realId = ZuulEntranceUtils.parseExecID((String)id)[3];
        try {
            job = this.entranceServer.getJob(realId);
        }
        catch (Exception var10) {
            logger.warn("can not find a job in entranceServer, will force to kill it", (Throwable)var10);
            JobHistoryHelper.forceKill((long)taskID);
            Message message2 = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
            message2.setMethod("/api/entrance/" + id + "/kill");
            message2.setStatus(0);
            return message2;
        }
        if (job.isEmpty()) {
            logger.warn("can not find a job in entranceServer, will force to kill it");
            JobHistoryHelper.forceKill((long)taskID);
            Message message3 = Message.ok((String)"Forced Kill task (\u5f3a\u5236\u6740\u6b7b\u4efb\u52a1)");
            message3.setMethod("/api/entrance/" + id + "/kill");
            message3.setStatus(0);
            return message3;
        }
        try {
            logger.info("begin to kill job {} ", (Object)((Job)job.get()).getId());
            ((Job)job.get()).kill();
            message = Message.ok((String)"Successfully killed the job(\u6210\u529fkill\u4e86job)");
            message.setMethod("/api/entrance/" + id + "/kill");
            message.setStatus(0);
            message.data("execID", (Object)id);
            if (job.get() instanceof EntranceJob) {
                EntranceJob entranceJob = (EntranceJob)job.get();
                JobRequest jobReq = entranceJob.getJobRequest();
                entranceJob.updateJobRequestStatus(SchedulerEventState.Cancelled().toString());
                this.entranceServer.getEntranceContext().getOrCreatePersistenceManager().createPersistenceEngine().updateIfNeeded(jobReq);
            }
            logger.info("end to kill job {} ", (Object)((Job)job.get()).getId());
        }
        catch (Throwable var9) {
            logger.error("kill job {} failed ", (Object)((Job)job.get()).getId(), (Object)var9);
            message = Message.error((String)"An exception occurred while killing the job, kill failed(kill job\u7684\u65f6\u5019\u51fa\u73b0\u4e86\u5f02\u5e38\uff0ckill\u5931\u8d25)");
            message.setMethod("/api/entrance/" + id + "/kill");
            message.setStatus(1);
        }
        return message;
    }

    private void pushLog(String log, Job job) {
        this.entranceServer.getEntranceContext().getOrCreateLogManager().onLogUpdate(job, log);
    }
}

