/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.dss.flow.execution.entrance.persistence;

import com.webank.wedatasphere.dss.flow.execution.entrance.service.WorkflowQueryService;
import com.webank.wedatasphere.dss.flow.execution.entrance.utils.FlowExecutionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.entrance.exception.EntranceIllegalParamException;
import org.apache.linkis.entrance.exception.EntranceRPCException;
import org.apache.linkis.entrance.exception.QueryFailedException;
import org.apache.linkis.entrance.persistence.AbstractPersistenceEngine;
import org.apache.linkis.governance.common.entity.job.JobRequest;
import org.apache.linkis.governance.common.entity.job.SubJobDetail;
import org.apache.linkis.governance.common.entity.job.SubJobInfo;
import org.apache.linkis.governance.common.entity.task.RequestInsertTask;
import org.apache.linkis.governance.common.entity.task.RequestPersistTask;
import org.apache.linkis.governance.common.entity.task.RequestReadAllTask;
import org.apache.linkis.governance.common.entity.task.RequestUpdateTask;
import org.apache.linkis.governance.common.entity.task.ResponsePersist;
import org.apache.linkis.protocol.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkflowPersistenceEngine
extends AbstractPersistenceEngine {
    @Autowired
    private WorkflowQueryService workflowQueryService;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowPersistenceEngine.class);

    public WorkflowPersistenceEngine() {
        logger.info("WorkflowPersistenceEngine Registered");
    }

    public void persist(JobRequest jobRequest) throws QueryFailedException, EntranceIllegalParamException, EntranceRPCException {
        if (jobRequest == null) {
            throw new EntranceIllegalParamException(20004, "task can not be null, unable to do persist operation");
        }
        RequestInsertTask requestInsertTask = new RequestInsertTask();
        RequestPersistTask requestPersistTask = FlowExecutionUtils.jobRequest2RequestPersistTask(jobRequest);
        BeanUtils.copyProperties((Object)requestPersistTask, (Object)requestInsertTask);
        ResponsePersist responsePersist = null;
        try {
            responsePersist = this.workflowQueryService.add(requestInsertTask, jobRequest);
        }
        catch (Exception e) {
            throw new EntranceRPCException(20020, "sender rpc failed", e);
        }
        if (responsePersist != null) {
            int status = responsePersist.getStatus();
            String message = responsePersist.getMsg();
            if (status != 0) {
                throw new QueryFailedException(20011, "insert task failed, reason: " + message);
            }
            Map data = responsePersist.getData();
            Object object = data.get("taskID");
            if (object == null) {
                throw new QueryFailedException(20011, "insert task failed, reason: " + message);
            }
            String taskStr = object.toString();
            Long taskID = Long.parseLong(taskStr);
            jobRequest.setId(taskID);
        }
    }

    public void persist(SubJobInfo subjobInfo) throws ErrorException {
    }

    public void updateIfNeeded(JobRequest jobRequest) throws EntranceRPCException, EntranceIllegalParamException {
        if (jobRequest == null) {
            throw new EntranceIllegalParamException(20004, "task can not be null, unable to do update operation");
        }
        RequestUpdateTask requestUpdateTask = new RequestUpdateTask();
        RequestPersistTask requestPersistTask = FlowExecutionUtils.jobRequest2RequestPersistTask(jobRequest);
        BeanUtils.copyProperties((Object)requestPersistTask, (Object)requestUpdateTask);
        try {
            this.workflowQueryService.change(requestUpdateTask);
        }
        catch (Exception e) {
            logger.error("Request to update task with taskID {} failed, possibly due to RPC failure(\u8bf7\u6c42\u66f4\u65b0taskID\u4e3a {} \u7684\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u53ef\u80fd\u662fRPC\u5931\u8d25)", (Object)requestUpdateTask.getTaskID(), (Object)e);
            throw new EntranceRPCException(20020, "sender rpc failed ", e);
        }
    }

    public void updateIfNeeded(SubJobInfo subJobInfo) throws ErrorException {
    }

    public Task[] readAll(String instance) throws EntranceIllegalParamException, EntranceRPCException, QueryFailedException {
        ArrayList<RequestPersistTask> retList = new ArrayList<RequestPersistTask>();
        if (instance == null || "".equals(instance)) {
            throw new EntranceIllegalParamException(20004, "instance can not be null");
        }
        RequestReadAllTask requestReadAllTask = new RequestReadAllTask(instance);
        Object responsePersist = null;
        if (responsePersist != null) {
            int status = responsePersist.getStatus();
            String message = responsePersist.getMsg();
            if (status != 0) {
                throw new QueryFailedException(20011, "read all tasks failed, reason: " + message);
            }
            Map data = responsePersist.getData();
            Object object = data.get("task");
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() == 0) {
                    logger.info("no running task in this instance: {}", (Object)instance);
                }
                for (Object o : list) {
                    if (!(o instanceof RequestPersistTask)) continue;
                    retList.add((RequestPersistTask)o);
                }
            }
        }
        return retList.toArray(new Task[0]);
    }

    public JobRequest retrieveJobReq(Long jobGroupId) throws ErrorException {
        return null;
    }

    public SubJobDetail retrieveJobDetailReq(Long jobDetailId) throws ErrorException {
        return null;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }
}

