/*
 * Decompiled with CFR 0.152.
 */
package com.wdullaer.materialdatetimepicker.time;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;
import com.wdullaer.materialdatetimepicker.R;

public class CircleView
extends View {
    private static final String TAG = "CircleView";
    private final Paint mPaint = new Paint();
    private boolean mIs24HourMode;
    private int mCircleColor;
    private int mDotColor;
    private float mCircleRadiusMultiplier;
    private float mAmPmCircleRadiusMultiplier;
    private boolean mIsInitialized;
    private boolean mDrawValuesReady;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;

    public CircleView(Context context) {
        super(context);
        Resources res = context.getResources();
        this.mCircleColor = res.getColor(R.color.mdtp_circle_color);
        this.mDotColor = res.getColor(R.color.mdtp_numbers_text_color);
        this.mPaint.setAntiAlias(true);
        this.mIsInitialized = false;
    }

    public void initialize(Context context, boolean is24HourMode) {
        if (this.mIsInitialized) {
            Log.e((String)TAG, (String)"CircleView may only be initialized once.");
            return;
        }
        Resources res = context.getResources();
        this.mIs24HourMode = is24HourMode;
        if (is24HourMode) {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier_24HourMode));
        } else {
            this.mCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_circle_radius_multiplier));
            this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(R.string.mdtp_ampm_circle_radius_multiplier));
        }
        this.mIsInitialized = true;
    }

    void setTheme(Context context, boolean dark) {
        Resources res = context.getResources();
        if (dark) {
            this.mCircleColor = res.getColor(R.color.mdtp_circle_background_dark_theme);
            this.mDotColor = res.getColor(R.color.mdtp_white);
        } else {
            this.mCircleColor = res.getColor(R.color.mdtp_circle_color);
            this.mDotColor = res.getColor(R.color.mdtp_numbers_text_color);
        }
    }

    public void onDraw(Canvas canvas) {
        int viewWidth = this.getWidth();
        if (viewWidth == 0 || !this.mIsInitialized) {
            return;
        }
        if (!this.mDrawValuesReady) {
            this.mXCenter = this.getWidth() / 2;
            this.mYCenter = this.getHeight() / 2;
            this.mCircleRadius = (int)((float)Math.min(this.mXCenter, this.mYCenter) * this.mCircleRadiusMultiplier);
            if (!this.mIs24HourMode) {
                int amPmCircleRadius = (int)((float)this.mCircleRadius * this.mAmPmCircleRadiusMultiplier);
                this.mYCenter = (int)((double)this.mYCenter - (double)amPmCircleRadius * 0.75);
            }
            this.mDrawValuesReady = true;
        }
        this.mPaint.setColor(this.mCircleColor);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, (float)this.mCircleRadius, this.mPaint);
        this.mPaint.setColor(this.mDotColor);
        canvas.drawCircle((float)this.mXCenter, (float)this.mYCenter, 4.0f, this.mPaint);
    }
}

