/*
 * Decompiled with CFR 0.152.
 */
package com.waynejo.androidndkgif;

import android.graphics.Bitmap;
import java.io.FileNotFoundException;
import java.util.Locale;

public class GifEncoder {
    private long instance = 0L;
    private int threadCount = 1;
    private int width;
    private int height;

    private native long nativeInit(int var1, int var2, String var3, int var4, int var5);

    private native void nativeClose(long var1);

    private native void nativeSetDither(long var1, boolean var3);

    private native void nativeSetThreadCount(long var1, int var3);

    private native boolean nativeEncodeFrame(long var1, Bitmap var3, int var4);

    public void init(int width, int height, String path) throws FileNotFoundException {
        this.init(width, height, path, EncodingType.ENCODING_TYPE_NORMAL_LOW_MEMORY);
    }

    public void init(int width, int height, String path, EncodingType encodingType) throws FileNotFoundException {
        if (0L != this.instance) {
            this.close();
        }
        this.width = width;
        this.height = height;
        this.instance = this.nativeInit(width, height, path, encodingType.ordinal(), this.threadCount);
        if (0L == this.instance) {
            throw new FileNotFoundException();
        }
    }

    public void close() {
        this.nativeClose(this.instance);
        this.instance = 0L;
    }

    public void setDither(boolean useDither) {
        if (0L == this.instance) {
            return;
        }
        this.nativeSetDither(this.instance, useDither);
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        if (0L == this.instance) {
            return;
        }
        this.nativeSetThreadCount(this.instance, threadCount);
    }

    public boolean encodeFrame(Bitmap bitmap, int delayMs) {
        if (0L == this.instance) {
            return false;
        }
        if (bitmap.getWidth() != this.width || bitmap.getHeight() != this.height) {
            String errorMessage = String.format(Locale.ENGLISH, "The size specified at initialization differs from the size of the image.\n expected:(%d, %d) actual:(%d,%d)", this.width, this.height, bitmap.getWidth(), bitmap.getHeight());
            throw new RuntimeException(errorMessage);
        }
        this.nativeEncodeFrame(this.instance, bitmap, delayMs);
        return true;
    }

    static {
        System.loadLibrary("androidndkgif");
    }

    public static enum EncodingType {
        ENCODING_TYPE_SIMPLE_FAST,
        ENCODING_TYPE_FAST,
        ENCODING_TYPE_NORMAL_LOW_MEMORY,
        ENCODING_TYPE_STABLE_HIGH_MEMORY;

    }
}

