/*
 * Decompiled with CFR 0.152.
 */
package com.waynejo.androidndkgif;

import android.graphics.Bitmap;
import com.waynejo.androidndkgif.GifImage;
import com.waynejo.androidndkgif.GifImageIterator;

public class GifDecoder {
    private int width = 0;
    private int height = 0;
    private Bitmap[] bitmaps = new Bitmap[0];
    private int[] delays = new int[0];
    private int frameNum;
    private boolean hasUnclosedIterator = false;

    private native long nativeInit();

    private native void nativeClose(long var1);

    private native boolean nativeLoad(long var1, String var3);

    private native long nativeLoadUsingIterator(long var1, String var3);

    private native int nativeGetFrameCount(long var1);

    private native Bitmap nativeGetFrame(long var1, int var3);

    private native int nativeGetDelay(long var1, int var3);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native boolean nativeBitmapIteratorHasNext(long var1);

    private native GifImage nativeBitmapIteratornext(long var1, long var3);

    public boolean load(String fileName) {
        long handle = this.nativeInit();
        if (!this.nativeLoad(handle, fileName)) {
            this.nativeClose(handle);
            return false;
        }
        this.width = this.nativeGetWidth(handle);
        this.height = this.nativeGetHeight(handle);
        this.frameNum = this.nativeGetFrameCount(handle);
        this.bitmaps = new Bitmap[this.frameNum];
        this.delays = new int[this.frameNum];
        for (int i = 0; i < this.frameNum; ++i) {
            this.bitmaps[i] = this.nativeGetFrame(handle, i);
            this.delays[i] = this.nativeGetDelay(handle, i);
        }
        this.nativeClose(handle);
        return true;
    }

    public GifImageIterator loadUsingIterator(String fileName) {
        if (this.hasUnclosedIterator) {
            return null;
        }
        final long handle = this.nativeInit();
        final long iteratorHandle = this.nativeLoadUsingIterator(handle, fileName);
        if (0L == iteratorHandle) {
            this.nativeClose(handle);
            return null;
        }
        this.width = this.nativeGetWidth(handle);
        this.height = this.nativeGetHeight(handle);
        this.hasUnclosedIterator = true;
        return new GifImageIterator(){
            boolean isClosed = false;

            @Override
            public boolean hasNext() {
                return GifDecoder.this.nativeBitmapIteratorHasNext(iteratorHandle);
            }

            @Override
            public GifImage next() {
                return GifDecoder.this.nativeBitmapIteratornext(handle, iteratorHandle);
            }

            @Override
            public void close() {
                if (!this.isClosed) {
                    GifDecoder.this.nativeClose(handle);
                    GifDecoder.this.hasUnclosedIterator = false;
                    this.isClosed = true;
                }
            }
        };
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public int frameNum() {
        return this.frameNum;
    }

    public Bitmap frame(int idx) {
        if (0 == this.frameNum) {
            return null;
        }
        return this.bitmaps[idx % this.frameNum];
    }

    public int delay(int idx) {
        if (0 == this.frameNum) {
            return 0;
        }
        return this.delays[idx % this.frameNum];
    }

    static {
        System.loadLibrary("androidndkgif");
    }
}

