/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wavefront.java_sdk.com.google.common.base.Throwables;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.service.ReportingService;
import com.wavefront.sdk.common.logging.MessageDedupingLogger;
import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontClient
implements WavefrontSender,
Runnable {
    private static final MessageDedupingLogger logger = new MessageDedupingLogger(Logger.getLogger(WavefrontClient.class.getCanonicalName()), LogMessageType.values().length, 0.02);
    private final String defaultSource;
    private final String clientId;
    private final int batchSize;
    private final int messageSizeBytes;
    private final LinkedBlockingQueue<String> metricsBuffer;
    private final LinkedBlockingQueue<String> histogramsBuffer;
    private final LinkedBlockingQueue<String> tracingSpansBuffer;
    private final LinkedBlockingQueue<String> spanLogsBuffer;
    private final ReportingService reportingService;
    private final ScheduledExecutorService scheduler;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private final WavefrontSdkCounter pointsValid;
    private final WavefrontSdkCounter pointsInvalid;
    private final WavefrontSdkCounter pointsDropped;
    private final WavefrontSdkCounter pointReportErrors;
    private final WavefrontSdkCounter histogramsValid;
    private final WavefrontSdkCounter histogramsInvalid;
    private final WavefrontSdkCounter histogramsDropped;
    private final WavefrontSdkCounter histogramReportErrors;
    private final WavefrontSdkCounter spansValid;
    private final WavefrontSdkCounter spansInvalid;
    private final WavefrontSdkCounter spansDropped;
    private final WavefrontSdkCounter spanReportErrors;
    private final WavefrontSdkCounter spanLogsValid;
    private final WavefrontSdkCounter spanLogsInvalid;
    private final WavefrontSdkCounter spanLogsDropped;
    private final WavefrontSdkCounter spanLogReportErrors;
    private final AtomicInteger metricsDisabledStatusCode;
    private final AtomicInteger histogramsDisabledStatusCode;
    private final AtomicInteger spansDisabledStatusCode;
    private final AtomicInteger spanLogsDisabledStatusCode;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private WavefrontClient(Builder builder) {
        String tempSource = "unknown";
        try {
            tempSource = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.log(LogMessageType.UNKNOWN_HOST.toString(), Level.WARNING, "Unable to resolve local host name. Source will default to 'unknown'");
        }
        this.defaultSource = tempSource;
        this.batchSize = builder.batchSize;
        this.messageSizeBytes = builder.messageSizeBytes;
        this.metricsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.histogramsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.tracingSpansBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.spanLogsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.reportingService = new ReportingService(builder.server, builder.token);
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("wavefrontClientSender"));
        this.scheduler.scheduleAtFixedRate(this, 1L, builder.flushIntervalSeconds, TimeUnit.SECONDS);
        String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        this.sdkMetricsRegistry = new WavefrontSdkMetricsRegistry.Builder(this).prefix("~sdk.java.core.sender.wfclient").tag("pid", processId).build();
        this.sdkMetricsRegistry.newGauge("points.queue.size", this.metricsBuffer::size);
        this.sdkMetricsRegistry.newGauge("points.queue.remaining_capacity", this.metricsBuffer::remainingCapacity);
        this.pointsValid = this.sdkMetricsRegistry.newCounter("points.valid");
        this.pointsInvalid = this.sdkMetricsRegistry.newCounter("points.invalid");
        this.pointsDropped = this.sdkMetricsRegistry.newCounter("points.dropped");
        this.pointReportErrors = this.sdkMetricsRegistry.newCounter("points.report.errors");
        this.sdkMetricsRegistry.newGauge("histograms.queue.size", this.histogramsBuffer::size);
        this.sdkMetricsRegistry.newGauge("histograms.queue.remaining_capacity", this.histogramsBuffer::remainingCapacity);
        this.histogramsValid = this.sdkMetricsRegistry.newCounter("histograms.valid");
        this.histogramsInvalid = this.sdkMetricsRegistry.newCounter("histograms.invalid");
        this.histogramsDropped = this.sdkMetricsRegistry.newCounter("histograms.dropped");
        this.histogramReportErrors = this.sdkMetricsRegistry.newCounter("histograms.report.errors");
        this.sdkMetricsRegistry.newGauge("spans.queue.size", this.tracingSpansBuffer::size);
        this.sdkMetricsRegistry.newGauge("spans.queue.remaining_capacity", this.tracingSpansBuffer::remainingCapacity);
        this.spansValid = this.sdkMetricsRegistry.newCounter("spans.valid");
        this.spansInvalid = this.sdkMetricsRegistry.newCounter("spans.invalid");
        this.spansDropped = this.sdkMetricsRegistry.newCounter("spans.dropped");
        this.spanReportErrors = this.sdkMetricsRegistry.newCounter("spans.report.errors");
        this.sdkMetricsRegistry.newGauge("span_logs.queue.size", this.spanLogsBuffer::size);
        this.sdkMetricsRegistry.newGauge("span_logs.queue.remaining_capacity", this.spanLogsBuffer::remainingCapacity);
        this.spanLogsValid = this.sdkMetricsRegistry.newCounter("span_logs.valid");
        this.spanLogsInvalid = this.sdkMetricsRegistry.newCounter("span_logs.invalid");
        this.spanLogsDropped = this.sdkMetricsRegistry.newCounter("span_logs.dropped");
        this.spanLogReportErrors = this.sdkMetricsRegistry.newCounter("span_logs.report.errors");
        this.metricsDisabledStatusCode = new AtomicInteger();
        this.histogramsDisabledStatusCode = new AtomicInteger();
        this.spansDisabledStatusCode = new AtomicInteger();
        this.spanLogsDisabledStatusCode = new AtomicInteger();
        this.clientId = builder.server;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void sendMetric(String name, double value, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String point;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            point = Utils.metricToLineData(name, value, timestamp, source, tags, this.defaultSource);
            this.pointsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.pointsInvalid.inc();
            throw e;
        }
        if (!this.metricsBuffer.offer(point)) {
            this.pointsDropped.inc();
            logger.log(LogMessageType.METRICS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping metric point: " + point + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendFormattedMetric(String point) throws IOException {
        String finalPoint;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        if (point == null || "".equals(point.trim())) {
            this.pointsInvalid.inc();
            throw new IllegalArgumentException("point must be non-null and in WF data format");
        }
        this.pointsValid.inc();
        String string = finalPoint = point.endsWith("\n") ? point : point + "\n";
        if (!this.metricsBuffer.offer(finalPoint)) {
            this.pointsDropped.inc();
            logger.log(LogMessageType.METRICS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping metric point: " + finalPoint + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String histograms;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            histograms = Utils.histogramToLineData(name, centroids, histogramGranularities, timestamp, source, tags, this.defaultSource);
            this.histogramsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.histogramsInvalid.inc();
            throw e;
        }
        if (!this.histogramsBuffer.offer(histograms)) {
            this.histogramsDropped.inc();
            logger.log(LogMessageType.HISTOGRAMS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping histograms: " + histograms + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendSpan(String name, long startMillis, long durationMillis, @Nullable String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) throws IOException {
        String span;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            span = Utils.tracingSpanToLineData(name, startMillis, durationMillis, source, traceId, spanId, parents, followsFrom, tags, spanLogs, this.defaultSource);
            this.spansValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.spansInvalid.inc();
            throw e;
        }
        if (this.tracingSpansBuffer.offer(span)) {
            if (spanLogs != null && !spanLogs.isEmpty()) {
                this.sendSpanLogs(traceId, spanId, spanLogs);
            }
        } else {
            this.spansDropped.inc();
            if (spanLogs != null && !spanLogs.isEmpty()) {
                this.spanLogsDropped.inc();
            }
            logger.log(LogMessageType.SPANS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping span: " + span + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    private void sendSpanLogs(UUID traceId, UUID spanId, List<SpanLog> spanLogs) {
        try {
            String spanLogsJson = Utils.spanLogsToLineData(traceId, spanId, spanLogs);
            this.spanLogsValid.inc();
            if (!this.spanLogsBuffer.offer(spanLogsJson)) {
                this.spanLogsDropped.inc();
                logger.log(LogMessageType.SPANLOGS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping spanLogs: " + spanLogsJson + ". Consider increasing the batch size of your sender to increase throughput.");
            }
        }
        catch (JsonProcessingException e) {
            this.spanLogsInvalid.inc();
            logger.log(LogMessageType.SPANLOGS_PROCESSING_ERROR.toString(), Level.WARNING, "Unable to serialize span logs to JSON: traceId=" + traceId + " spanId=" + spanId + " spanLogs=" + spanLogs);
        }
    }

    @Override
    public void run() {
        try {
            this.flush();
        }
        catch (Throwable ex) {
            logger.log(LogMessageType.FLUSH_ERROR.toString(), Level.WARNING, "Unable to report to Wavefront cluster: " + Throwables.getRootCause(ex));
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed.get()) {
            throw new IOException("attempt to flush closed sender");
        }
        this.flushNoCheck();
    }

    private void flushNoCheck() throws IOException {
        this.internalFlush(this.metricsBuffer, "wavefront", "points", "points", this.pointsDropped, this.pointReportErrors, this.metricsDisabledStatusCode, LogMessageType.SEND_METRICS_ERROR, LogMessageType.SEND_METRICS_PERMISSIONS, LogMessageType.METRICS_BUFFER_FULL);
        this.internalFlush(this.histogramsBuffer, "histogram", "histograms", "histograms", this.histogramsDropped, this.histogramReportErrors, this.histogramsDisabledStatusCode, LogMessageType.SEND_HISTOGRAMS_ERROR, LogMessageType.SEND_HISTOGRAMS_PERMISSIONS, LogMessageType.HISTOGRAMS_BUFFER_FULL);
        this.internalFlush(this.tracingSpansBuffer, "trace", "spans", "spans", this.spansDropped, this.spanReportErrors, this.spansDisabledStatusCode, LogMessageType.SEND_SPANS_ERROR, LogMessageType.SEND_SPANS_PERMISSIONS, LogMessageType.SPANS_BUFFER_FULL);
        this.internalFlush(this.spanLogsBuffer, "spanLogs", "span_logs", "span logs", this.spanLogsDropped, this.spanLogReportErrors, this.spanLogsDisabledStatusCode, LogMessageType.SEND_SPANLOGS_ERROR, LogMessageType.SEND_SPANLOGS_PERMISSIONS, LogMessageType.SPANLOGS_BUFFER_FULL);
    }

    /*
     * Unable to fully structure code
     */
    private void internalFlush(LinkedBlockingQueue<String> buffer, String format, String entityPrefix, String entityType, WavefrontSdkCounter dropped, WavefrontSdkCounter reportErrors, AtomicInteger featureDisabledStatusCode, LogMessageType errorMessageType, LogMessageType permissionsMessageType, LogMessageType bufferFullMessageType) throws IOException {
        batch = WavefrontClient.getBatch(buffer, this.batchSize, this.messageSizeBytes, dropped);
        block19: for (i = 0; i < batch.size(); ++i) {
            items = batch.get(i);
            featureDisabledReason = featureDisabledStatusCode.get();
            if (featureDisabledReason != 0) {
                switch (featureDisabledReason) {
                    case 401: {
                        WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that your API Token is correct! All " + entityType + " will be discarded until the service is restarted.");
                        break;
                    }
                    case 403: {
                        if (format.equals("wavefront")) {
                            WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that Direct Data Ingestion is enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            break;
                        }
                        WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that Direct Data Ingestion and " + entityType + " are enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                    }
                }
                continue;
            }
            try {
                is = this.itemsToStream(items);
                var16_17 = null;
                try {
                    statusCode = this.reportingService.send(format, is);
                    this.sdkMetricsRegistry.newCounter(entityPrefix + ".report." + statusCode).inc();
                    if (400 > statusCode || statusCode > 599) continue;
                    switch (statusCode) {
                        case 401: {
                            WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that your API Token is correct! All " + entityType + " will be discarded until the service is restarted.");
                            featureDisabledStatusCode.set(statusCode);
                            dropped.inc(items.size());
                            ** break;
lbl29:
                            // 1 sources

                            continue block19;
                        }
                        case 403: {
                            if (format.equals("wavefront")) {
                                WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that Direct Data Ingestion is enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            } else {
                                WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that Direct Data Ingestion and " + entityType + " are enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            }
                            featureDisabledStatusCode.set(statusCode);
                            dropped.inc(items.size());
                            ** break;
lbl38:
                            // 1 sources

                            continue block19;
                        }
                        default: {
                            WavefrontClient.logger.log(errorMessageType.toString(), Level.WARNING, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Data will be requeued and resent.");
                            this.requeue(buffer, items, dropped, entityType, bufferFullMessageType);
                            continue block19;
                        }
                    }
                }
                catch (Throwable var17_21) {
                    var16_17 = var17_21;
                    throw var17_21;
                }
                finally {
                    if (is != null) {
                        if (var16_17 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var17_20) {
                                var16_17.addSuppressed(var17_20);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                dropped.inc(items.size());
                reportErrors.inc();
                for (j = i + 1; j < batch.size(); ++j) {
                    dropped.inc(batch.get(j).size());
                }
                throw ex;
            }
        }
    }

    private void requeue(LinkedBlockingQueue<String> buffer, List<String> items, WavefrontSdkCounter dropped, String entityType, LogMessageType bufferFullMessageType) {
        int numAddedBackToBuffer = 0;
        for (String item : items) {
            if (buffer.offer(item)) {
                ++numAddedBackToBuffer;
                continue;
            }
            int numDropped = items.size() - numAddedBackToBuffer;
            dropped.inc(numDropped);
            logger.log(bufferFullMessageType.toString(), Level.WARNING, "Buffer full, dropping " + numDropped + " " + entityType + ". Consider increasing the batch size of your sender to increase throughput.");
            break;
        }
    }

    private InputStream itemsToStream(List<String> items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    @Override
    public int getFailureCount() {
        return (int)(this.pointReportErrors.count() + this.histogramReportErrors.count() + this.spanReportErrors.count());
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            logger.log(LogMessageType.CLOSE_WHILE_CLOSED.toString(), Level.FINE, "attempt to close already closed sender");
        }
        try {
            this.flushNoCheck();
        }
        catch (IOException e) {
            logger.log(LogMessageType.FLUSH_ERROR.toString(), Level.WARNING, "error flushing buffer: " + Throwables.getRootCause(e));
        }
        this.sdkMetricsRegistry.close();
        try {
            Utils.shutdownExecutorAndWait(this.scheduler);
        }
        catch (SecurityException ex) {
            logger.log(LogMessageType.SHUTDOWN_ERROR.toString(), Level.WARNING, "shutdown error: " + Throwables.getRootCause(ex));
        }
    }

    static List<List<String>> getBatch(LinkedBlockingQueue<String> buffer, int batchSize, int messageSizeBytes, WavefrontSdkCounter dropped) {
        String item;
        batchSize = Math.min(buffer.size(), batchSize);
        ArrayList<List<String>> batch = new ArrayList<List<String>>();
        ArrayList<String> chunk = new ArrayList<String>();
        int numBytesInChunk = 0;
        int count = 0;
        while (count < batchSize && (item = buffer.poll()) != null) {
            int numBytes = item.getBytes().length;
            if (numBytes > messageSizeBytes) {
                logger.log(LogMessageType.MESSAGE_SIZE_LIMIT_EXCEEDED.toString(), Level.WARNING, "Dropping data larger than " + messageSizeBytes + " bytes: " + item + ". Consider increasing the message size limit of your sender.");
                dropped.inc();
                continue;
            }
            if (numBytesInChunk + numBytes > messageSizeBytes) {
                if (!chunk.isEmpty()) {
                    batch.add(chunk);
                }
                chunk = new ArrayList();
                numBytesInChunk = 0;
            }
            chunk.add(item);
            numBytesInChunk += numBytes;
            ++count;
        }
        if (!chunk.isEmpty()) {
            batch.add(chunk);
        }
        return batch;
    }

    private static enum LogMessageType {
        UNKNOWN_HOST,
        METRICS_BUFFER_FULL,
        HISTOGRAMS_BUFFER_FULL,
        SPANS_BUFFER_FULL,
        SPANLOGS_BUFFER_FULL,
        SPANLOGS_PROCESSING_ERROR,
        FLUSH_ERROR,
        CLOSE_WHILE_CLOSED,
        SEND_METRICS_ERROR,
        SEND_HISTOGRAMS_ERROR,
        SEND_SPANS_ERROR,
        SEND_SPANLOGS_ERROR,
        SEND_METRICS_PERMISSIONS,
        SEND_HISTOGRAMS_PERMISSIONS,
        SEND_SPANS_PERMISSIONS,
        SEND_SPANLOGS_PERMISSIONS,
        SHUTDOWN_ERROR,
        MESSAGE_SIZE_LIMIT_EXCEEDED;

    }

    public static class Builder {
        private final String server;
        private final String token;
        private int maxQueueSize = 50000;
        private int batchSize = 10000;
        private int flushIntervalSeconds = 1;
        private int messageSizeBytes = Integer.MAX_VALUE;

        public Builder(String server, @Nullable String token) {
            this.server = server;
            this.token = token;
        }

        public Builder(String proxyServer) {
            this.server = proxyServer;
            this.token = null;
        }

        public Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder flushIntervalSeconds(int flushIntervalSeconds) {
            this.flushIntervalSeconds = flushIntervalSeconds;
            return this;
        }

        public Builder messageSizeBytes(int bytes) {
            this.messageSizeBytes = bytes;
            return this;
        }

        public WavefrontClient build() {
            return new WavefrontClient(this);
        }
    }
}

