/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.application;

import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeartbeaterService
implements Runnable,
Closeable {
    private static final Logger logger = Logger.getLogger(HeartbeaterService.class.getCanonicalName());
    private final WavefrontMetricSender wavefrontMetricSender;
    private final Map<String, String> heartbeatMetricTags;
    private final ScheduledExecutorService scheduler;
    private final String source;

    public HeartbeaterService(WavefrontMetricSender wavefrontMetricSender, final ApplicationTags applicationTags, final String component, String source) {
        this.wavefrontMetricSender = wavefrontMetricSender;
        this.source = source;
        this.heartbeatMetricTags = new HashMap<String, String>(){
            {
                this.put("application", applicationTags.getApplication());
                this.put("cluster", applicationTags.getCluster() == null ? "none" : applicationTags.getCluster());
                this.put("service", applicationTags.getService());
                this.put("shard", applicationTags.getShard() == null ? "none" : applicationTags.getShard());
                this.put("component", component);
            }
        };
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory(component + "-heart-beater"));
        this.scheduler.scheduleAtFixedRate(this, 1L, 5L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        try {
            this.wavefrontMetricSender.sendMetric("~component.heartbeat", 1.0, System.currentTimeMillis(), this.source, this.heartbeatMetricTags);
        }
        catch (Throwable t) {
            logger.warning("Cannot report ~component.heartbeat to Wavefront");
        }
    }

    @Override
    public void close() {
        try {
            this.scheduler.shutdownNow();
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "shutdown error", ex);
        }
    }
}

