/*
 * Decompiled with CFR 0.152.
 */
package com.warrenstrange.googleauth;

import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.HmacHashFunction;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.http.client.utils.URIBuilder;

public final class GoogleAuthenticatorQRGenerator {
    private static final String TOTP_URI_FORMAT = "https://chart.googleapis.com/chart?chs=200x200&chld=M%%7C0&cht=qr&chl=%s";

    private static String internalURLEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported by URLEncoder.", e);
        }
    }

    private static String formatLabel(String issuer, String accountName) {
        if (accountName == null || accountName.trim().length() == 0) {
            throw new IllegalArgumentException("Account name must not be empty.");
        }
        StringBuilder sb = new StringBuilder();
        if (issuer != null) {
            if (issuer.contains(":")) {
                throw new IllegalArgumentException("Issuer cannot contain the ':' character.");
            }
            sb.append(issuer);
            sb.append(":");
        }
        sb.append(accountName);
        return sb.toString();
    }

    public static String getOtpAuthURL(String issuer, String accountName, GoogleAuthenticatorKey credentials) {
        return String.format(TOTP_URI_FORMAT, GoogleAuthenticatorQRGenerator.internalURLEncode(GoogleAuthenticatorQRGenerator.getOtpAuthTotpURL(issuer, accountName, credentials)));
    }

    public static String getOtpAuthTotpURL(String issuer, String accountName, GoogleAuthenticatorKey credentials) {
        URIBuilder uri = new URIBuilder().setScheme("otpauth").setHost("totp").setPath("/" + GoogleAuthenticatorQRGenerator.formatLabel(issuer, accountName)).setParameter("secret", credentials.getKey());
        if (issuer != null) {
            if (issuer.contains(":")) {
                throw new IllegalArgumentException("Issuer cannot contain the ':' character.");
            }
            uri.setParameter("issuer", issuer);
        }
        GoogleAuthenticatorConfig config = credentials.getConfig();
        uri.setParameter("algorithm", GoogleAuthenticatorQRGenerator.getAlgorithmName(config.getHmacHashFunction()));
        uri.setParameter("digits", String.valueOf(config.getCodeDigits()));
        uri.setParameter("period", String.valueOf((int)(config.getTimeStepSizeInMillis() / 1000L)));
        return uri.toString();
    }

    private static String getAlgorithmName(HmacHashFunction hashFunction) {
        switch (hashFunction) {
            case HmacSHA1: {
                return "SHA1";
            }
            case HmacSHA256: {
                return "SHA256";
            }
            case HmacSHA512: {
                return "SHA512";
            }
        }
        throw new IllegalArgumentException(String.format("Unknown algorithm %s", new Object[]{hashFunction}));
    }
}

