/*
 * Decompiled with CFR 0.152.
 */
package com.wanderingcan.persistentsearch;

import com.wanderingcan.persistentsearch.SearchMenuItem;
import com.wanderingcan.persistentsearch.SearchMenuPresenter;
import java.util.ArrayList;
import java.util.Collections;

public class SearchMenu {
    private static final String TAG = "SearchMenu";
    private static final int DEFAULT_SIZE = 5;
    private ArrayList<SearchMenuItem> mItems;
    private SearchMenuPresenter mPresenter;

    private SearchMenu() {
    }

    protected SearchMenu(SearchMenuPresenter presenter) {
        this.mPresenter = presenter;
        this.mItems = new ArrayList();
    }

    protected ArrayList<SearchMenuItem> getItems() {
        return this.mItems;
    }

    protected int getCount() {
        return this.mItems.size();
    }

    public int maxSearchMenuItems() {
        return 5;
    }

    public SearchMenuItem addSearchMenuItem(int id) {
        return this.internalAddSearchMenuItem(id, null, Integer.MAX_VALUE);
    }

    public SearchMenuItem addSearchMenuItem(int id, String title) {
        return this.internalAddSearchMenuItem(id, title, Integer.MAX_VALUE);
    }

    public SearchMenuItem addSearchMenuItem(int id, int order) {
        return this.internalAddSearchMenuItem(id, null, order);
    }

    public SearchMenuItem addSearchMenuItem(int id, String title, int order) {
        return this.internalAddSearchMenuItem(id, title, order);
    }

    private SearchMenuItem internalAddSearchMenuItem(int id, String title, int order) {
        if (this.mItems.size() < 5) {
            SearchMenuItem item = new SearchMenuItem(this.mPresenter, id, order, title);
            this.mItems.add(item);
            Collections.sort(this.mItems);
            int index = this.mItems.indexOf(item);
            this.mPresenter.mAdapter.notifyItemInserted(index);
            return item;
        }
        return null;
    }

    public SearchMenuItem getSearchMenuItem(int id) {
        for (SearchMenuItem item : this.mItems) {
            if (item.getId() != id) continue;
            return item;
        }
        return null;
    }

    public SearchMenuItem getSearchMenuItem(String title) {
        for (SearchMenuItem item : this.mItems) {
            if (!item.getTitle().equals(title)) continue;
            return item;
        }
        return null;
    }

    public boolean removeSearchMenuItem(SearchMenuItem item) {
        int index = this.mItems.indexOf(item);
        if (index != -1) {
            this.mItems.remove(item);
            this.mPresenter.mAdapter.notifyItemRemoved(index);
            return true;
        }
        return false;
    }

    public void clearItems() {
        this.mItems.clear();
        this.mPresenter.mAdapter.notifyDataSetChanged();
    }
}

