/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.RecordingFormat;
import com.vonage.client.voice.ncco.SplitRecording;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RecordAction
implements Action {
    private static final String ACTION = "record";
    private RecordingFormat format;
    private Integer endOnSilence;
    private Character endOnKey;
    private Integer timeOut;
    private Boolean beepStart;
    private Collection<String> eventUrl;
    private EventMethod eventMethod;
    private SplitRecording split;
    private Integer channels;

    @Deprecated
    public RecordAction(Builder builder) {
        this.format = builder.format;
        this.endOnSilence = builder.endOnSilence;
        this.endOnKey = builder.endOnKey;
        this.timeOut = builder.timeOut;
        this.beepStart = builder.beepStart;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
        this.split = builder.channels != null && builder.channels > 1 ? SplitRecording.CONVERSATION : builder.split;
        this.channels = builder.channels;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public RecordingFormat getFormat() {
        return this.format;
    }

    public Integer getEndOnSilence() {
        return this.endOnSilence;
    }

    public Character getEndOnKey() {
        return this.endOnKey;
    }

    public Integer getTimeOut() {
        return this.timeOut;
    }

    public Boolean getBeepStart() {
        return this.beepStart;
    }

    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public SplitRecording getSplit() {
        return this.split;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RecordingFormat format = null;
        private Integer endOnSilence = null;
        private Character endOnKey = null;
        private Integer timeOut = null;
        private Boolean beepStart = null;
        private Collection<String> eventUrl = null;
        private EventMethod eventMethod = null;
        private SplitRecording split = null;
        private Integer channels = null;

        public Builder format(RecordingFormat format) {
            this.format = format;
            return this;
        }

        public Builder endOnSilence(Integer endOnSilence) {
            this.endOnSilence = endOnSilence;
            return this;
        }

        public Builder endOnKey(Character endOnKey) {
            this.endOnKey = endOnKey;
            return this;
        }

        public Builder timeOut(Integer timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder beepStart(Boolean beepStart) {
            this.beepStart = beepStart;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder split(SplitRecording split) {
            this.split = split;
            return this;
        }

        public Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public RecordAction build() {
            return new RecordAction(this);
        }
    }
}

