/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.EventMethod;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConversationAction
implements Action {
    private static final String ACTION = "conversation";
    private String name;
    private Collection<String> musicOnHoldUrl;
    private Boolean startOnEnter;
    private Boolean endOnExit;
    private Boolean record;
    private Collection<String> eventUrl;
    private EventMethod eventMethod;

    private ConversationAction(Builder builder) {
        this.name = builder.name;
        this.musicOnHoldUrl = builder.musicOnHoldUrl;
        this.startOnEnter = builder.startOnEnter;
        this.endOnExit = builder.endOnExit;
        this.record = builder.record;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getMusicOnHoldUrl() {
        return this.musicOnHoldUrl;
    }

    public Boolean getStartOnEnter() {
        return this.startOnEnter;
    }

    public Boolean getEndOnExit() {
        return this.endOnExit;
    }

    public Boolean getRecord() {
        return this.record;
    }

    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String name;
        private Collection<String> musicOnHoldUrl = null;
        private Boolean startOnEnter = null;
        private Boolean endOnExit = null;
        private Boolean record = null;
        private Collection<String> eventUrl = null;
        private EventMethod eventMethod = null;

        public Builder(String name) {
            this.name = name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder musicOnHoldUrl(Collection<String> musicOnHoldUrl) {
            this.musicOnHoldUrl = musicOnHoldUrl;
            return this;
        }

        public Builder musicOnHoldUrl(String ... musicOnHoldUrl) {
            return this.musicOnHoldUrl(Arrays.asList(musicOnHoldUrl));
        }

        public Builder startOnEnter(Boolean startOnEnter) {
            this.startOnEnter = startOnEnter;
            return this;
        }

        public Builder endOnExit(Boolean endOnExit) {
            this.endOnExit = endOnExit;
            return this;
        }

        public Builder record(Boolean record) {
            this.record = record;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public ConversationAction build() {
            return new ConversationAction(this);
        }
    }
}

