/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CallStatus {
    STARTED,
    RINGING,
    ANSWERED,
    TIMEOUT,
    MACHINE,
    COMPLETED,
    FAILED,
    REJECTED,
    BUSY,
    CANCELLED,
    UNKNOWN;

    private static final Map<String, CallStatus> CALL_STATUS_INDEX;

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static CallStatus fromString(String name) {
        CallStatus foundCallStatus = CALL_STATUS_INDEX.get(name.toUpperCase());
        return foundCallStatus != null ? foundCallStatus : UNKNOWN;
    }

    static {
        CALL_STATUS_INDEX = new HashMap<String, CallStatus>();
        for (CallStatus callStatus : CallStatus.values()) {
            CALL_STATUS_INDEX.put(callStatus.name(), callStatus);
        }
    }
}

