/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.legacyutils;

import com.vonage.client.VonageResponseParseException;
import com.vonage.client.legacyutils.XmlUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class XmlParser {
    private final Lock documentBuilderLock = new ReentrantLock();
    private DocumentBuilder documentBuilder;

    public Document parseXml(String xml) throws VonageResponseParseException {
        Document doc;
        this.documentBuilderLock.lock();
        try {
            if (this.documentBuilder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            doc = XmlUtil.parseXmlString(this.documentBuilder, xml);
        }
        catch (ParserConfigurationException e) {
            throw new VonageResponseParseException("Exception initialing XML parser", e);
        }
        finally {
            this.documentBuilderLock.unlock();
        }
        return doc;
    }
}

