/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.insight;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.insight.CallerType;
import com.vonage.client.insight.RoamingDetails;
import com.vonage.client.insight.StandardInsightResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AdvancedInsightResponse
extends StandardInsightResponse {
    private Validity validNumber;
    private Reachability reachability;
    private PortedStatus ported;
    private Integer lookupOutcome;
    private String lookupOutcomeMessage;
    private RoamingDetails roaming;
    private String callerName;
    private String firstName;
    private String lastName;
    private CallerType callerType;

    public static AdvancedInsightResponse fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (AdvancedInsightResponse)mapper.readValue(json, AdvancedInsightResponse.class);
        }
        catch (IOException jpe) {
            throw new VonageUnexpectedException("Failed to produce AdvancedInsightResponse from json.", jpe);
        }
    }

    @JsonProperty(value="valid_number")
    public Validity getValidNumber() {
        return this.validNumber;
    }

    @JsonProperty(value="reachable")
    public Reachability getReachability() {
        return this.reachability;
    }

    public PortedStatus getPorted() {
        return this.ported;
    }

    @JsonProperty(value="lookup_outcome")
    public Integer getLookupOutcome() {
        return this.lookupOutcome;
    }

    @JsonProperty(value="lookup_outcome_message")
    public String getLookupOutcomeMessage() {
        return this.lookupOutcomeMessage;
    }

    public RoamingDetails getRoaming() {
        return this.roaming;
    }

    @JsonProperty(value="caller_name")
    public String getCallerName() {
        return this.callerName;
    }

    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="caller_type")
    public CallerType getCallerType() {
        return this.callerType;
    }

    public static enum Validity {
        UNKNOWN,
        VALID,
        NOT_VALID;

        private static final Map<String, Validity> VALIDITY_INDEX;

        @JsonCreator
        public static Validity fromString(String name) {
            Validity foundValidity = VALIDITY_INDEX.get(name.toUpperCase());
            return foundValidity != null ? foundValidity : UNKNOWN;
        }

        static {
            VALIDITY_INDEX = new HashMap<String, Validity>();
            for (Validity validity : Validity.values()) {
                VALIDITY_INDEX.put(validity.name(), validity);
            }
        }
    }

    public static enum Reachability {
        UNKNOWN,
        REACHABLE,
        UNDELIVERABLE,
        ABSENT,
        BAD_NUMBER,
        BLACKLISTED;

        private static final Map<String, Reachability> REACHABILITY_INDEX;

        @JsonCreator
        public static Reachability fromString(String name) {
            Reachability foundReachability = REACHABILITY_INDEX.get(name.toUpperCase());
            return foundReachability != null ? foundReachability : UNKNOWN;
        }

        static {
            REACHABILITY_INDEX = new HashMap<String, Reachability>();
            for (Reachability reachability : Reachability.values()) {
                REACHABILITY_INDEX.put(reachability.name(), reachability);
            }
        }
    }

    public static enum PortedStatus {
        UNKNOWN,
        PORTED,
        NOT_PORTED,
        ASSUMED_NOT_PORTED,
        ASSUMED_PORTED;

        private static final Map<String, PortedStatus> PORTED_STATUS_INDEX;

        @JsonCreator
        public static PortedStatus fromString(String name) {
            PortedStatus foundPortedStatus = PORTED_STATUS_INDEX.get(name.toUpperCase());
            return foundPortedStatus != null ? foundPortedStatus : UNKNOWN;
        }

        static {
            PORTED_STATUS_INDEX = new HashMap<String, PortedStatus>();
            for (PortedStatus portedStatus : PortedStatus.values()) {
                PORTED_STATUS_INDEX.put(portedStatus.name(), portedStatus);
            }
        }
    }
}

