/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.incoming;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum CallStatus {
    STARTED,
    RINGING,
    ANSWERED,
    COMPLETED,
    MACHINE,
    HUMAN,
    INPUT,
    BUSY,
    CANCELLED,
    FAILED,
    RECORDING,
    REJECTED,
    TIMEOUT,
    UNANSWERED,
    UNKNOWN;

    private static final Map<String, CallStatus> CALL_STATUS_INDEX;

    @JsonCreator
    public static CallStatus fromString(String status) {
        CallStatus foundCallStatus = CALL_STATUS_INDEX.get(status.toUpperCase());
        return foundCallStatus != null ? foundCallStatus : UNKNOWN;
    }

    static {
        CALL_STATUS_INDEX = new HashMap<String, CallStatus>();
        for (CallStatus callStatus : CallStatus.values()) {
            CALL_STATUS_INDEX.put(callStatus.name(), callStatus);
        }
    }
}

