/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.VonageUnacceptableAuthException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AuthCollection {
    private SortedSet<AuthMethod> authList;

    public AuthCollection() {
        this.authList = new TreeSet<AuthMethod>();
    }

    public AuthCollection(AuthMethod ... authMethods) {
        this();
        for (AuthMethod method : authMethods) {
            this.add(method);
        }
    }

    public AuthCollection(SortedSet<AuthMethod> authMethods) {
        this.authList = authMethods;
    }

    public void add(AuthMethod auth) {
        this.authList.add(auth);
    }

    public <T extends AuthMethod> T getAuth(Class<T> type) throws VonageUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            if (!type.isInstance(availableAuthMethod)) continue;
            return (T)availableAuthMethod;
        }
        throw new VonageUnacceptableAuthException(this.authList, new HashSet<Class>(Arrays.asList(type)));
    }

    public AuthMethod getAcceptableAuthMethod(Set<Class> acceptableAuthMethodClasses) throws VonageUnacceptableAuthException {
        for (AuthMethod availableAuthMethod : this.authList) {
            if (!acceptableAuthMethodClasses.contains(availableAuthMethod.getClass())) continue;
            return availableAuthMethod;
        }
        throw new VonageUnacceptableAuthException(this.authList, acceptableAuthMethodClasses);
    }
}

