/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.account.PrefixPricingRequest;
import com.vonage.client.account.PrefixPricingResponse;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

class PrefixPricingMethod
extends AbstractMethod<PrefixPricingRequest, PrefixPricingResponse> {
    private static final Class[] ALLOWED_AUTH_METHODS = new Class[]{TokenAuthMethod.class};
    private static final String PATH = "/get-prefix-pricing/outbound/";

    PrefixPricingMethod(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(PrefixPricingRequest prefixPricingRequest) {
        String uri = this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH + prefixPricingRequest.getServiceType().name().toLowerCase();
        return RequestBuilder.get((String)uri).addParameter("prefix", prefixPricingRequest.getPrefix());
    }

    @Override
    public PrefixPricingResponse parseResponse(HttpResponse response) throws IOException {
        return PrefixPricingResponse.fromJson(new BasicResponseHandler().handleResponse(response));
    }
}

