/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.AbstractClient;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.account.BalanceEndpoint;
import com.vonage.client.account.BalanceResponse;
import com.vonage.client.account.CreateSecretRequest;
import com.vonage.client.account.ListSecretsResponse;
import com.vonage.client.account.PrefixPricingEndpoint;
import com.vonage.client.account.PrefixPricingRequest;
import com.vonage.client.account.PrefixPricingResponse;
import com.vonage.client.account.PricingEndpoint;
import com.vonage.client.account.PricingRequest;
import com.vonage.client.account.PricingResponse;
import com.vonage.client.account.SecretManagementEndpoint;
import com.vonage.client.account.SecretRequest;
import com.vonage.client.account.SecretResponse;
import com.vonage.client.account.ServiceType;
import com.vonage.client.account.SettingsEndpoint;
import com.vonage.client.account.SettingsRequest;
import com.vonage.client.account.SettingsResponse;
import com.vonage.client.account.TopUpEndpoint;
import com.vonage.client.account.TopUpRequest;

public class AccountClient
extends AbstractClient {
    protected BalanceEndpoint balance;
    protected PricingEndpoint pricing;
    protected PrefixPricingEndpoint prefixPricing;
    protected TopUpEndpoint topUp;
    protected SecretManagementEndpoint secret;
    protected SettingsEndpoint settings;

    public AccountClient(HttpWrapper httpWrapper) {
        super(httpWrapper);
        this.balance = new BalanceEndpoint(httpWrapper);
        this.pricing = new PricingEndpoint(httpWrapper);
        this.prefixPricing = new PrefixPricingEndpoint(httpWrapper);
        this.topUp = new TopUpEndpoint(httpWrapper);
        this.secret = new SecretManagementEndpoint(httpWrapper);
        this.settings = new SettingsEndpoint(httpWrapper);
    }

    public BalanceResponse getBalance() throws VonageResponseParseException, VonageClientException {
        return this.balance.execute();
    }

    public PricingResponse getVoicePrice(String country) throws VonageResponseParseException, VonageClientException {
        return this.getVoicePrice(new PricingRequest(country));
    }

    private PricingResponse getVoicePrice(PricingRequest pricingRequest) throws VonageResponseParseException, VonageClientException {
        return this.pricing.getPrice(ServiceType.VOICE, pricingRequest);
    }

    public PricingResponse getSmsPrice(String country) throws VonageResponseParseException, VonageClientException {
        return this.getSmsPrice(new PricingRequest(country));
    }

    private PricingResponse getSmsPrice(PricingRequest pricingRequest) throws VonageResponseParseException, VonageClientException {
        return this.pricing.getPrice(ServiceType.SMS, pricingRequest);
    }

    public PrefixPricingResponse getPrefixPrice(ServiceType type, String prefix) throws VonageResponseParseException, VonageClientException {
        return this.getPrefixPrice(new PrefixPricingRequest(type, prefix));
    }

    private PrefixPricingResponse getPrefixPrice(PrefixPricingRequest prefixPricingRequest) throws VonageResponseParseException, VonageClientException {
        return this.prefixPricing.getPrice(prefixPricingRequest);
    }

    public void topUp(String transaction) throws VonageResponseParseException, VonageClientException {
        this.topUp(new TopUpRequest(transaction));
    }

    private void topUp(TopUpRequest request) throws VonageResponseParseException, VonageClientException {
        this.topUp.topUp(request);
    }

    public ListSecretsResponse listSecrets(String apiKey) throws VonageResponseParseException, VonageClientException {
        return this.secret.listSecrets(apiKey);
    }

    public SecretResponse getSecret(String apiKey, String secretId) throws VonageResponseParseException, VonageClientException {
        return this.getSecret(new SecretRequest(apiKey, secretId));
    }

    private SecretResponse getSecret(SecretRequest secretRequest) throws VonageResponseParseException, VonageClientException {
        return this.secret.getSecret(secretRequest);
    }

    public SecretResponse createSecret(String apiKey, String secret) throws VonageResponseParseException, VonageClientException {
        return this.createSecret(new CreateSecretRequest(apiKey, secret));
    }

    private SecretResponse createSecret(CreateSecretRequest createSecretRequest) throws VonageResponseParseException, VonageClientException {
        return this.secret.createSecret(createSecretRequest);
    }

    public void revokeSecret(String apiKey, String secretId) throws VonageResponseParseException, VonageClientException {
        this.revokeSecret(new SecretRequest(apiKey, secretId));
    }

    private void revokeSecret(SecretRequest secretRequest) throws VonageResponseParseException, VonageClientException {
        this.secret.revokeSecret(secretRequest);
    }

    public SettingsResponse updateSmsIncomingUrl(String url) throws VonageResponseParseException, VonageClientException {
        return this.updateSettings(SettingsRequest.withIncomingSmsUrl(url));
    }

    public SettingsResponse updateDeliveryReceiptUrl(String url) throws VonageResponseParseException, VonageClientException {
        return this.updateSettings(SettingsRequest.withDeliveryReceiptUrl(url));
    }

    public SettingsResponse updateSettings(SettingsRequest request) throws VonageResponseParseException, VonageClientException {
        return this.settings.updateSettings(request);
    }
}

