/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.service.vikingDB.common;

import com.google.gson.internal.LinkedTreeMap;
import com.volcengine.service.vikingDB.VikingDBException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class VectorizeTuple {
    private static final String PARAM_DENSE = "dense";
    private static final String PARAM_SPARSE = "sparse";
    private static final String PARAM_TEXT_FIELD = "text_field";
    private static final String PARAM_IMAGE_FIELD = "image_field";
    private static final String PARAM_MODEL_NAME = "model_name";
    private static final String PARAM_MODEL_VERSION = "model_version";
    private static final String PARAM_DIM = "dim";
    private VectorizeModelConf dense = null;
    private VectorizeModelConf sparse = null;
    private Integer isBuild = 0;

    public VectorizeTuple setDense(VectorizeModelConf dense) {
        this.dense = dense;
        return this;
    }

    public VectorizeTuple setSparse(VectorizeModelConf sparse) {
        this.sparse = sparse;
        return this;
    }

    public VectorizeTuple build() throws Exception {
        VikingDBException vikingDBException = new VikingDBException(1000030, null, "Params does not exist");
        if (this.dense == null) {
            throw vikingDBException.getErrorCodeException(1000030, null, "Dense model vectorize conf does not exist");
        }
        if (this.dense.getIsBuild() == 0) {
            throw vikingDBException.getErrorCodeException(1000030, null, "Dense model vectorize conf does not build");
        }
        if (this.sparse != null && this.sparse.getIsBuild() == 0) {
            throw vikingDBException.getErrorCodeException(1000030, null, "Sparse model vectorize conf does not build");
        }
        this.isBuild = 1;
        return this;
    }

    public static List<VectorizeTuple> getVectorizeFromList(List<LinkedTreeMap<String, Object>> vectorizeList) {
        List<VectorizeTuple> result = vectorizeList.stream().map(VectorizeTuple::getVectorizeTupleFromMap).filter(Objects::nonNull).collect(Collectors.toList());
        return result.isEmpty() ? null : result;
    }

    public static VectorizeTuple getVectorizeTupleFromMap(LinkedTreeMap<String, Object> vectorizeTupleMap) {
        try {
            VectorizeTuple vectorizeTuple = new VectorizeTuple();
            if (vectorizeTupleMap.containsKey((Object)PARAM_DENSE)) {
                LinkedTreeMap denseObj = (LinkedTreeMap)vectorizeTupleMap.get((Object)PARAM_DENSE);
                VectorizeModelConf denseConf = VectorizeTuple.getVectorizeModelConfFromMap((LinkedTreeMap<String, Object>)denseObj);
                vectorizeTuple.setDense(denseConf);
            }
            if (vectorizeTupleMap.containsKey((Object)PARAM_SPARSE)) {
                LinkedTreeMap sparseObj = (LinkedTreeMap)vectorizeTupleMap.get((Object)PARAM_SPARSE);
                VectorizeModelConf sparseConf = VectorizeTuple.getVectorizeModelConfFromMap((LinkedTreeMap<String, Object>)sparseObj);
                vectorizeTuple.setSparse(sparseConf);
            }
            return vectorizeTuple.build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static VectorizeModelConf getVectorizeModelConfFromMap(LinkedTreeMap<String, Object> vectorizeConfMap) {
        try {
            VectorizeModelConf vectorizeModelConf = new VectorizeModelConf();
            if (vectorizeConfMap.containsKey((Object)PARAM_TEXT_FIELD)) {
                String textField = (String)vectorizeConfMap.get((Object)PARAM_TEXT_FIELD);
                vectorizeModelConf.setTextField(textField);
            }
            if (vectorizeConfMap.containsKey((Object)PARAM_IMAGE_FIELD)) {
                String imageField = (String)vectorizeConfMap.get((Object)PARAM_IMAGE_FIELD);
                vectorizeModelConf.setImageField(imageField);
            }
            if (vectorizeConfMap.containsKey((Object)PARAM_MODEL_NAME)) {
                String modelName = (String)vectorizeConfMap.get((Object)PARAM_MODEL_NAME);
                vectorizeModelConf.setModelName(modelName);
            }
            if (vectorizeConfMap.containsKey((Object)PARAM_MODEL_VERSION)) {
                String modelVersion = (String)vectorizeConfMap.get((Object)PARAM_MODEL_VERSION);
                vectorizeModelConf.setModelVersion(modelVersion);
            }
            if (vectorizeConfMap.containsKey((Object)PARAM_DIM)) {
                Long dim = (Long)vectorizeConfMap.get((Object)PARAM_DIM);
                vectorizeModelConf.setDim(dim.intValue());
            }
            return vectorizeModelConf.build();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Map<String, Object>> getVectorizeToMapList(List<VectorizeTuple> vectorize) throws Exception {
        if (vectorize == null) {
            return null;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(vectorize.size());
        for (VectorizeTuple v : vectorize) {
            VikingDBException vikingDBException = new VikingDBException(1000030, null, "Params does not exist");
            if (v == null || v.getIsBuild() == 0) {
                throw vikingDBException.getErrorCodeException(1000030, null, "Vectorize item does not build");
            }
            result.add(VectorizeTuple.getVectorizeTupleToMap(v));
        }
        return result;
    }

    public static Map<String, Object> getVectorizeTupleToMap(VectorizeTuple vectorizeTuple) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(PARAM_DENSE, VectorizeTuple.getVectorizeModelConfToMap(vectorizeTuple.dense));
        if (vectorizeTuple.sparse != null) {
            result.put(PARAM_SPARSE, VectorizeTuple.getVectorizeModelConfToMap(vectorizeTuple.sparse));
        }
        return result;
    }

    public static Map<String, Object> getVectorizeModelConfToMap(VectorizeModelConf vectorizeConf) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (vectorizeConf.getTextField() != null) {
            result.put(PARAM_TEXT_FIELD, vectorizeConf.getTextField());
        }
        if (vectorizeConf.getImageField() != null) {
            result.put(PARAM_IMAGE_FIELD, vectorizeConf.getImageField());
        }
        if (vectorizeConf.getModelName() != null) {
            result.put(PARAM_MODEL_NAME, vectorizeConf.getModelName());
        }
        if (vectorizeConf.getModelVersion() != null) {
            result.put(PARAM_MODEL_VERSION, vectorizeConf.getModelVersion());
        }
        if (vectorizeConf.getDim() != null) {
            result.put(PARAM_DIM, vectorizeConf.getDim());
        }
        return result;
    }

    public VectorizeModelConf getDense() {
        return this.dense;
    }

    public VectorizeModelConf getSparse() {
        return this.sparse;
    }

    public Integer getIsBuild() {
        return this.isBuild;
    }

    public void setIsBuild(Integer isBuild) {
        this.isBuild = isBuild;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorizeTuple)) {
            return false;
        }
        VectorizeTuple other = (VectorizeTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$isBuild = this.getIsBuild();
        Integer other$isBuild = other.getIsBuild();
        if (this$isBuild == null ? other$isBuild != null : !((Object)this$isBuild).equals(other$isBuild)) {
            return false;
        }
        VectorizeModelConf this$dense = this.getDense();
        VectorizeModelConf other$dense = other.getDense();
        if (this$dense == null ? other$dense != null : !((Object)this$dense).equals(other$dense)) {
            return false;
        }
        VectorizeModelConf this$sparse = this.getSparse();
        VectorizeModelConf other$sparse = other.getSparse();
        return !(this$sparse == null ? other$sparse != null : !((Object)this$sparse).equals(other$sparse));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorizeTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $isBuild = this.getIsBuild();
        result = result * 59 + ($isBuild == null ? 43 : ((Object)$isBuild).hashCode());
        VectorizeModelConf $dense = this.getDense();
        result = result * 59 + ($dense == null ? 43 : ((Object)$dense).hashCode());
        VectorizeModelConf $sparse = this.getSparse();
        result = result * 59 + ($sparse == null ? 43 : ((Object)$sparse).hashCode());
        return result;
    }

    public String toString() {
        return "VectorizeTuple(dense=" + this.getDense() + ", sparse=" + this.getSparse() + ", isBuild=" + this.getIsBuild() + ")";
    }

    public static class VectorizeModelConf {
        private String textField = null;
        private String imageField = null;
        private String modelName = null;
        private String modelVersion = null;
        private Integer dim = null;
        private Integer isBuild = 0;

        public VectorizeModelConf setTextField(String textField) {
            this.textField = textField;
            return this;
        }

        public VectorizeModelConf setImageField(String imageField) {
            this.imageField = imageField;
            return this;
        }

        public VectorizeModelConf setModelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public VectorizeModelConf setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public VectorizeModelConf setDim(Integer dim) {
            this.dim = dim;
            return this;
        }

        public VectorizeModelConf build() throws Exception {
            this.isBuild = 1;
            return this;
        }

        public String getTextField() {
            return this.textField;
        }

        public String getImageField() {
            return this.imageField;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getModelVersion() {
            return this.modelVersion;
        }

        public Integer getDim() {
            return this.dim;
        }

        public Integer getIsBuild() {
            return this.isBuild;
        }

        public void setIsBuild(Integer isBuild) {
            this.isBuild = isBuild;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VectorizeModelConf)) {
                return false;
            }
            VectorizeModelConf other = (VectorizeModelConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$dim = this.getDim();
            Integer other$dim = other.getDim();
            if (this$dim == null ? other$dim != null : !((Object)this$dim).equals(other$dim)) {
                return false;
            }
            Integer this$isBuild = this.getIsBuild();
            Integer other$isBuild = other.getIsBuild();
            if (this$isBuild == null ? other$isBuild != null : !((Object)this$isBuild).equals(other$isBuild)) {
                return false;
            }
            String this$textField = this.getTextField();
            String other$textField = other.getTextField();
            if (this$textField == null ? other$textField != null : !this$textField.equals(other$textField)) {
                return false;
            }
            String this$imageField = this.getImageField();
            String other$imageField = other.getImageField();
            if (this$imageField == null ? other$imageField != null : !this$imageField.equals(other$imageField)) {
                return false;
            }
            String this$modelName = this.getModelName();
            String other$modelName = other.getModelName();
            if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
                return false;
            }
            String this$modelVersion = this.getModelVersion();
            String other$modelVersion = other.getModelVersion();
            return !(this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VectorizeModelConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $dim = this.getDim();
            result = result * 59 + ($dim == null ? 43 : ((Object)$dim).hashCode());
            Integer $isBuild = this.getIsBuild();
            result = result * 59 + ($isBuild == null ? 43 : ((Object)$isBuild).hashCode());
            String $textField = this.getTextField();
            result = result * 59 + ($textField == null ? 43 : $textField.hashCode());
            String $imageField = this.getImageField();
            result = result * 59 + ($imageField == null ? 43 : $imageField.hashCode());
            String $modelName = this.getModelName();
            result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
            String $modelVersion = this.getModelVersion();
            result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
            return result;
        }

        public String toString() {
            return "VectorizeTuple.VectorizeModelConf(textField=" + this.getTextField() + ", imageField=" + this.getImageField() + ", modelName=" + this.getModelName() + ", modelVersion=" + this.getModelVersion() + ", dim=" + this.getDim() + ", isBuild=" + this.getIsBuild() + ")";
        }
    }
}

