/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcac.code.stream.jenkins.plugin;

import com.vmware.vcac.code.stream.jenkins.plugin.CodeStreamPipelineCallable;
import com.vmware.vcac.code.stream.jenkins.plugin.model.PipelineParam;
import com.vmware.vcac.code.stream.jenkins.plugin.model.PluginParam;
import com.vmware.vcac.code.stream.jenkins.plugin.util.EnvVariableResolver;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CodeStreamBuilder
extends Builder
implements Serializable {
    private String serverUrl;
    private String userName;
    private String password;
    private String tenant;
    private String pipelineName;
    private boolean waitExec;
    private List<PipelineParam> pipelineParams;

    @DataBoundConstructor
    public CodeStreamBuilder(String serverUrl, String userName, String password, String tenant, String pipelineName, boolean waitExec, List<PipelineParam> pipelineParams) {
        this.serverUrl = Util.fixEmptyAndTrim((String)serverUrl);
        this.userName = Util.fixEmptyAndTrim((String)userName);
        this.password = Util.fixEmptyAndTrim((String)password);
        this.tenant = Util.fixEmptyAndTrim((String)tenant);
        this.pipelineName = Util.fixEmptyAndTrim((String)pipelineName);
        this.waitExec = waitExec;
        this.pipelineParams = pipelineParams;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public List<PipelineParam> getPipelineParams() {
        return this.pipelineParams;
    }

    public boolean isWaitExec() {
        return this.waitExec;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        EnvVariableResolver helper = new EnvVariableResolver(build, listener);
        PluginParam param = new PluginParam(helper.replaceBuildParamWithValue(this.serverUrl), helper.replaceBuildParamWithValue(this.userName), helper.replaceBuildParamWithValue(this.password), helper.replaceBuildParamWithValue(this.tenant), helper.replaceBuildParamWithValue(this.pipelineName), this.waitExec, helper.replaceBuildParamWithValue(this.pipelineParams));
        logger.println("Starting CodeStream pipeline execution of pipeline : " + param.getPipelineName());
        param.validate();
        CodeStreamPipelineCallable callable = new CodeStreamPipelineCallable(param);
        Map envVariables = (Map)launcher.getChannel().call((Callable)callable);
        CodeStreamEnvAction action = new CodeStreamEnvAction();
        action.addAll(envVariables);
        build.addAction((Action)action);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class CodeStreamEnvAction
    implements EnvironmentContributingAction {
        private transient Map<String, String> data = new HashMap<String, String>();

        private void add(String key, String val) {
            if (this.data == null) {
                return;
            }
            this.data.put(key, val);
        }

        private void addAll(Map<String, String> map) {
            this.data.putAll(map);
        }

        public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
            if (this.data != null) {
                env.putAll(this.data);
            }
        }

        public String getIconFileName() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public String getUrlName() {
            return null;
        }

        public Map<String, String> getData() {
            return this.data;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final Logger log = Logger.getLogger(DescriptorImpl.class.getName());

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute CodeStream Pipeline";
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter CodeStream server URL.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            try {
                new URL(value).toURI();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"This is not a valid URI");
            }
            catch (URISyntaxException e) {
                return FormValidation.error((String)"This is not a valid URI");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUserName(@QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter user name.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter password.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.error((String)"Environment variable cannot be used in password.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTenant(@QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter tenant.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPipelineName(@QueryParameter String value) {
            String url = Util.fixEmptyAndTrim((String)value);
            if (url == null) {
                return FormValidation.error((String)"Please enter pipeline name.");
            }
            if (url.indexOf(36) >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.ok();
        }
    }
}

