/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiskQueueUtils {
    private static Logger logger = LoggerFactory.getLogger(DiskQueueUtils.class);
    private static final String L10N_TMP_DIR = "l10n" + File.separator + "tmp" + File.separator;
    private static final String L10N_TMP_SOURCE_PATH = L10N_TMP_DIR + "source" + File.separator;
    public static final String L10N_TMP_GRM_PATH = L10N_TMP_DIR + "grm" + File.separator;
    public static final String L10N_TMP_I18N_PATH = L10N_TMP_DIR + "i18n" + File.separator;
    public static final String L10N_TMP_BACKUP_PATH = L10N_TMP_DIR + "backup" + File.separator;
    private static final String L10N_TMP_EXCEP_PATH = L10N_TMP_DIR + "excep" + File.separator;
    private static final String SourceStr = "source_";

    private DiskQueueUtils() {
    }

    public static File createQueueFile(Map<String, ComponentSourceDTO> sources, String basePath) throws JsonGenerationException, JsonMappingException, IOException {
        String tmpFileDir = basePath + L10N_TMP_SOURCE_PATH;
        return DiskQueueUtils.createJsonFile((String)tmpFileDir, sources, (int)sources.size());
    }

    private static File createJsonFile(String fileDir, Object obj, int sourceSize) throws JsonGenerationException, JsonMappingException, IOException {
        File tmpFile = null;
        String tempFileName = null;
        while ((tmpFile = new File(tempFileName = fileDir + "tmp_" + System.currentTimeMillis() + "_" + sourceSize + ".json")).exists()) {
        }
        if (!tmpFile.getParentFile().exists()) {
            tmpFile.getParentFile().mkdirs();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writeValue(tmpFile, obj);
        File file = new File(tempFileName);
        if (file.exists()) {
            String resultFileName = tempFileName.replace("tmp_", "source_");
            File resultFile = new File(resultFileName);
            if (file.renameTo(resultFile)) {
                return resultFile;
            }
            throw new RuntimeException("disk queue rename file error!!");
        }
        return null;
    }

    public static List<File> listSourceQueueFile(String basePath) {
        File file = new File(basePath + L10N_TMP_SOURCE_PATH);
        return DiskQueueUtils.listQueueFiles((File)file);
    }

    public static List<File> listQueueFiles(File dir) {
        File[] files = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (files != null) {
            return Arrays.asList(files);
        }
        return null;
    }

    public static Map<String, ComponentSourceDTO> getQueueFile2Obj(File file) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map resultMap = (Map)objectMapper.readValue(file, Map.class);
        HashMap<String, ComponentSourceDTO> result = new HashMap<String, ComponentSourceDTO>();
        for (Map.Entry entry : resultMap.entrySet()) {
            ComponentSourceDTO dto = (ComponentSourceDTO)objectMapper.convertValue(entry.getValue(), ComponentSourceDTO.class);
            result.put((String)entry.getKey(), dto);
        }
        return result;
    }

    public static void moveQueueFile(File source, File target) throws IOException {
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void moveFile2ExceptPath(String basePath, File source, String prefix) {
        String targetFileName = basePath + L10N_TMP_EXCEP_PATH + source.getName().replace("source_", "source_" + prefix + "_");
        File file = new File(targetFileName);
        try {
            DiskQueueUtils.moveQueueFile((File)source, (File)file);
        }
        catch (IOException e) {
            logger.error("move file to Exception path error:", (Throwable)e);
        }
    }

    public static void copyFile2ExceptPath(String basePath, File source, String prefix) {
        String targetFileName = basePath + L10N_TMP_EXCEP_PATH + source.getName().replace("source_", "source_" + prefix + "_");
        File target = new File(targetFileName);
        try {
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error("move file to Exception path error:", (Throwable)e);
        }
    }

    public static List<File> listExceptQueueFile(String basePath) {
        File file = new File(basePath + L10N_TMP_EXCEP_PATH);
        return DiskQueueUtils.listQueueFiles((File)file);
    }

    public static void moveFile2GRMPath(String basePath, File source) throws IOException {
        String targetFileName = basePath + L10N_TMP_GRM_PATH + source.getName();
        File file = new File(targetFileName);
        DiskQueueUtils.moveQueueFile((File)source, (File)file);
    }

    public static void moveFile2I18nPath(String basePath, File source) throws IOException {
        String targetFileName = basePath + L10N_TMP_I18N_PATH + source.getName();
        File file = new File(targetFileName);
        DiskQueueUtils.moveQueueFile((File)source, (File)file);
    }

    public static void moveFile2IBackupPath(String basePath, File source, String fromPath) throws IOException {
        String targetFileName = basePath + L10N_TMP_BACKUP_PATH + source.getName().replace("source_", "source_" + fromPath + "_");
        File file = new File(targetFileName);
        DiskQueueUtils.moveQueueFile((File)source, (File)file);
    }

    public static void delQueueFile(File file) throws IOException {
        Files.delete(file.toPath());
    }
}

