/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.translation.readers;

import com.vmware.vip.common.l10n.source.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LocalJSONReader {
    private static Logger LOGGER = LoggerFactory.getLogger(LocalJSONReader.class);

    public String getTranslationOutJar(String filePath) throws IOException {
        String result = "";
        String localTranslationPath = PathUtil.getProjectAbsolutePath().replace("\\", "/") + "/" + filePath;
        LOGGER.info("[file path out of jar] {}", (Object)localTranslationPath);
        result = this.readLocalJSONFile(localTranslationPath);
        if (StringUtils.isEmpty((Object)result)) {
            URL url = this.getClass().getResource("/" + filePath.replace("\\", "/"));
            LOGGER.info("[file path in jar] {}", (Object)url.getPath());
            result = IOUtils.toString((URL)url, (String)"UTF-8");
        }
        return result;
    }

    public String readLocalJSONFile(String path) {
        String result = "";
        try {
            result = FileUtils.readFileToString((File)new File(path), (String)"UTF-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

