/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.translation.dao.impl;

import com.amazonaws.util.json.Jackson;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.vmware.l10n.conf.S3Client;
import com.vmware.l10n.translation.dao.SingleComponentDao;
import com.vmware.l10n.translation.dto.ComponentMessagesDTO;
import com.vmware.l10n.utils.S3Util;
import com.vmware.vip.common.constants.ConstantsFile;
import com.vmware.vip.common.constants.TranslationQueryStatusType;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.dto.UpdateTranslationDTO;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Objects;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
@Profile(value={"s3"})
public class S3SingleComponentDaoImpl
implements SingleComponentDao {
    private static Logger logger = LoggerFactory.getLogger(S3SingleComponentDaoImpl.class);
    @Value(value="${translation.bundle.file.basepath}")
    private String basePath;
    @Autowired
    private S3Util s3util;
    @Autowired
    private S3Client s3Client;

    @PostConstruct
    private void init() {
        if (this.basePath.startsWith("/")) {
            this.basePath = this.basePath.substring(1);
        }
        if (!this.basePath.isEmpty() && !this.basePath.endsWith("/")) {
            this.basePath = this.basePath + "/";
        }
        this.basePath = this.basePath + ConstantsFile.L10N_BUNDLES_PATH;
        this.basePath = this.basePath.replace("\\", "/");
    }

    public ComponentMessagesDTO getTranslationFromFile(ComponentMessagesDTO componentMessagesDTO) throws L10nAPIException {
        SingleComponentDTO caseComponentMessagesDTO;
        logger.debug("[get Translation from S3]");
        String bundleString = null;
        if (this.s3util.isBundleExist(this.basePath, (SingleComponentDTO)componentMessagesDTO)) {
            componentMessagesDTO.setStatus("Translation" + TranslationQueryStatusType.FileFound.toString());
            bundleString = this.s3util.readBundle(this.basePath, (SingleComponentDTO)componentMessagesDTO);
        }
        if (StringUtils.isEmpty(bundleString)) {
            componentMessagesDTO.setStatus(TranslationQueryStatusType.ComponentNotFound.toString());
            return componentMessagesDTO;
        }
        try {
            caseComponentMessagesDTO = SingleComponentDTO.getSingleComponentDTOWithLinkedMessages(bundleString);
            caseComponentMessagesDTO.setProductName(componentMessagesDTO.getProductName());
            caseComponentMessagesDTO.setVersion(componentMessagesDTO.getVersion());
            caseComponentMessagesDTO.setStatus(componentMessagesDTO.getStatus());
        }
        catch (ParseException e) {
            throw new L10nAPIException("Parsing json failed.", (Throwable)e);
        }
        ComponentMessagesDTO msgDTO = new ComponentMessagesDTO();
        BeanUtils.copyProperties((Object)caseComponentMessagesDTO, (Object)msgDTO);
        return msgDTO;
    }

    public boolean writeTranslationToFile(ComponentMessagesDTO componentMessagesDTO) throws JsonProcessingException {
        if (this.s3util.isBundleExist(this.basePath, (SingleComponentDTO)componentMessagesDTO)) {
            logger.debug("The bunlde file is found, update the bundle file.");
        } else {
            logger.debug("The bunlde file is not found, cascade create the dir,add new bundle file ");
        }
        return this.s3util.writeBundle(this.basePath, (SingleComponentDTO)componentMessagesDTO);
    }

    public boolean lockFile(ComponentMessagesDTO componentMessagesDTO) {
        S3Util s3Util = this.s3util;
        Objects.requireNonNull(s3Util);
        S3Util.Locker locker = new S3Util.Locker(s3Util, this.basePath, (SingleComponentDTO)componentMessagesDTO);
        return locker.lockFile();
    }

    public void unlockFile(ComponentMessagesDTO componentMessagesDTO) {
        S3Util s3Util = this.s3util;
        Objects.requireNonNull(s3Util);
        S3Util.Locker locker = new S3Util.Locker(s3Util, this.basePath, (SingleComponentDTO)componentMessagesDTO);
        locker.unlockFile();
    }

    public void saveCreationInfo(UpdateTranslationDTO updateTranslationDTO) {
        UpdateTranslationDTO.UpdateTranslationDataDTO transData = updateTranslationDTO.getData();
        UpdateTranslationDTO.UpdateTranslationDataDTO.CreationDTO creationDTO = transData.getCreation();
        String opId = creationDTO == null ? "" : creationDTO.getOperationid();
        String filepath = S3Util.genProductVersionS3Path((String)this.basePath, (String)transData.getProductName(), (String)transData.getVersion()) + "creation.json";
        HashMap jsonMap = this.s3Client.isObjectExist(filepath) ? (HashMap)Jackson.fromJsonString((String)this.s3Client.readObject(filepath), HashMap.class) : new HashMap();
        transData.getTranslation().forEach(translation -> jsonMap.put(translation.getLocale(), opId));
        this.s3Client.putObject(filepath, Jackson.toJsonPrettyString((Object)jsonMap));
    }
}

