/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.translation.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.l10n.translation.dto.ComponentMessagesDTO;
import com.vmware.l10n.translation.service.TranslationSyncServerService;
import com.vmware.vip.common.exceptions.ValidationException;
import com.vmware.vip.common.i18n.dto.UpdateTranslationDTO;
import com.vmware.vip.common.i18n.dto.response.APIResponseDTO;
import com.vmware.vip.common.i18n.status.APIResponseStatus;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.utils.RegExpValidatorUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TranslationSyncServerController {
    private static Logger LOGGER = LoggerFactory.getLogger(TranslationSyncServerController.class);
    @Autowired
    TranslationSyncServerService translationSyncServerService;

    @CrossOrigin
    @RequestMapping(value={"/l10n/api/v1/source/products/{productName}/versions/{version:.+}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public APIResponseDTO updateTranslation(@RequestBody UpdateTranslationDTO updateTranslationDTO, @PathVariable(value="productName") String productName, @PathVariable(value="version") String version, HttpServletRequest request) throws ValidationException {
        LOGGER.info("The request url is " + request.getRequestURL() + (String)(request.getQueryString() == null ? "" : "?" + request.getQueryString()));
        ObjectMapper mapper = new ObjectMapper();
        String requestJson = "";
        try {
            requestJson = mapper.writeValueAsString((Object)updateTranslationDTO);
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        LOGGER.info("The request content is {}", (Object)requestJson);
        APIResponseDTO response = new APIResponseDTO();
        if (StringUtils.isEmpty((Object)updateTranslationDTO) || StringUtils.isEmpty((Object)updateTranslationDTO.getData()) || StringUtils.isEmpty((Object)updateTranslationDTO.getData().getTranslation())) {
            response.setResponse(APIResponseStatus.BAD_REQUEST);
            return response;
        }
        UpdateTranslationDTO.UpdateTranslationDataDTO updateTranslationDataDTO = updateTranslationDTO.getData();
        List translationList = updateTranslationDataDTO.getTranslation();
        if (StringUtils.isEmpty((Object)updateTranslationDataDTO.getProductName()) || !updateTranslationDataDTO.getProductName().equals(productName)) {
            response.setResponse(APIResponseStatus.BAD_REQUEST);
            return response;
        }
        if (StringUtils.isEmpty((Object)updateTranslationDataDTO.getVersion()) || !updateTranslationDataDTO.getVersion().equals(version)) {
            response.setResponse(APIResponseStatus.BAD_REQUEST);
            return response;
        }
        ArrayList<ComponentMessagesDTO> componentMessagesDTOList = new ArrayList<ComponentMessagesDTO>();
        for (UpdateTranslationDTO.UpdateTranslationDataDTO.TranslationDTO translationDTO : translationList) {
            if (StringUtils.isEmpty((Object)translationDTO)) {
                response.setResponse(APIResponseStatus.BAD_REQUEST);
                return response;
            }
            ComponentMessagesDTO componentMessagesDTO = new ComponentMessagesDTO();
            componentMessagesDTO.setProductName(updateTranslationDataDTO.getProductName());
            componentMessagesDTO.setVersion(updateTranslationDataDTO.getVersion());
            componentMessagesDTO.setComponent(translationDTO.getComponent());
            componentMessagesDTO.setLocale(translationDTO.getLocale());
            Map msgs = translationDTO.getMessages();
            this.validateKeys(msgs);
            componentMessagesDTO.setMessages((Object)msgs);
            componentMessagesDTO.setId(System.currentTimeMillis());
            componentMessagesDTOList.add(componentMessagesDTO);
        }
        List translationDTOList = null;
        try {
            translationDTOList = this.translationSyncServerService.updateBatchTranslation(componentMessagesDTOList);
        }
        catch (L10nAPIException e) {
            response.setResponse(APIResponseStatus.INTERNAL_SERVER_ERROR);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            response.setResponse(APIResponseStatus.BAD_REQUEST);
            return response;
        }
        if (translationDTOList != null && translationDTOList.size() > 0) {
            response.setData((Object)translationDTOList);
            response.setResponse(APIResponseStatus.OK);
        }
        this.translationSyncServerService.saveCreationInfo(updateTranslationDTO);
        return response;
    }

    public void validateKeys(Map<String, String> msgs) throws ValidationException {
        for (Map.Entry<String, String> entry : msgs.entrySet()) {
            String key = entry.getKey();
            if (RegExpValidatorUtils.isAscii((String)key)) continue;
            throw new ValidationException(String.format("Incorrect key name '%s' contains non-ASCII char(only allows standard ASCII char)", key));
        }
    }
}

