/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.service.impl;

import com.vmware.l10n.source.service.SyncI18nSourceService;
import com.vmware.l10n.utils.DiskQueueUtils;
import com.vmware.vip.common.exceptions.VIPHttpException;
import com.vmware.vip.common.http.HTTPRequester;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SyncI18nSourceServiceImpl
implements SyncI18nSourceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncI18nSourceServiceImpl.class);
    private static final String LOCAL_STR = "local";
    private static final String I18N_STR = "i18n";
    @Value(value="${source.bundle.file.basepath}")
    private String basePath;
    @Value(value="${vip.server.url}")
    private String remoteVIPURL;
    @Value(value="${vip.server.authentication.enable}")
    private boolean remoteVIPAuthEnable;
    @Value(value="${vip.server.authentication.appId:#}")
    private String remoteVIPAuthAppId;
    @Value(value="${vip.server.authentication.token:#}")
    private String remoteVIPAuthAppToken;
    private boolean singletonConnected = false;

    public void sendSourceToI18n() {
        if (LOCAL_STR.equalsIgnoreCase(this.remoteVIPURL)) {
            return;
        }
        try {
            this.pingSingleton(this.remoteVIPURL);
            this.setSingletonConnected(true);
            this.processSingletonQueueFiles();
        }
        catch (L10nAPIException e) {
            LOGGER.error("Remote [" + this.remoteVIPURL + "] is not connected.", (Throwable)e);
            this.setSingletonConnected(false);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void processSingletonQueueFiles() {
        List queueFiles = DiskQueueUtils.listQueueFiles((File)new File(this.basePath + DiskQueueUtils.L10N_TMP_I18N_PATH));
        if (queueFiles == null) {
            return;
        }
        LOGGER.debug("the Singleton cache file size---{}", (Object)queueFiles.size());
        for (File quefile : queueFiles) {
            try {
                Map mapObj = DiskQueueUtils.getQueueFile2Obj((File)quefile);
                for (Map.Entry entry : mapObj.entrySet()) {
                    ComponentSourceDTO cachedComDTO = (ComponentSourceDTO)entry.getValue();
                    this.sendData2RemoteVIP(cachedComDTO);
                }
                DiskQueueUtils.moveFile2IBackupPath((String)this.basePath, (File)quefile, (String)I18N_STR);
            }
            catch (VIPHttpException e) {
                LOGGER.error("Send source file to Singleton error:", (Throwable)e);
                break;
            }
            catch (Exception e) {
                LOGGER.error("Read source file from singleton directory error:" + quefile.getAbsolutePath(), (Throwable)e);
                DiskQueueUtils.moveFile2ExceptPath((String)this.basePath, (File)quefile, (String)I18N_STR);
            }
        }
    }

    private void sendData2RemoteVIP(ComponentSourceDTO cachedComDTO) throws VIPHttpException {
        if (!StringUtils.isEmpty((Object)cachedComDTO) && this.isSingletonConnected()) {
            String urlStr = this.remoteVIPURL + "/i18n/api/v2/translation/products/{productName}/versions/{version:.+}".replace("{productName}", cachedComDTO.getProductName()).replace("{version:.+}", cachedComDTO.getVersion());
            String locale = "latest";
            String jsonStr = "{\"data\":{\"productName\": \"" + cachedComDTO.getProductName() + "\",\"pseudo\": false,\"translation\": [{\"component\": \"" + cachedComDTO.getComponent() + "\",\"locale\": \"" + locale + "\",\"messages\": " + cachedComDTO.getMessages().toJSONString() + "}],\"version\": \"" + cachedComDTO.getVersion() + "\"},\"requester\": \"SourceCollector\"}";
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("csp-auth-token", "SourceCollector");
            if (this.remoteVIPAuthEnable) {
                header.put("appId", this.remoteVIPAuthAppId);
                header.put("token", this.remoteVIPAuthAppToken);
            }
            HTTPRequester.putJSONStr((String)jsonStr, (String)urlStr, header);
        } else if (!this.isSingletonConnected()) {
            throw new VIPHttpException("remote singleton service not available");
        }
    }

    private void pingSingleton(String remoteURL) throws L10nAPIException {
        String reqUrl = remoteURL + "/i18n/api/v2/locale/browserLocale";
        HashMap<String, String> header = null;
        if (this.remoteVIPAuthEnable) {
            header = new HashMap<String, String>();
            header.put("appId", this.remoteVIPAuthAppId);
            header.put("token", this.remoteVIPAuthAppToken);
        }
        if (StringUtils.isEmpty((Object)HTTPRequester.getData((String)reqUrl, (String)"GET", header))) {
            throw new L10nAPIException("Error occur when send to singleton [" + reqUrl + "].");
        }
    }

    private boolean isSingletonConnected() {
        return this.singletonConnected;
    }

    private void setSingletonConnected(boolean singletonConnected) {
        this.singletonConnected = singletonConnected;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

