/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.service.impl;

import com.vmware.l10n.source.dao.SourceDao;
import com.vmware.l10n.source.dto.GRMAPIResponseStatus;
import com.vmware.l10n.source.dto.GRMResponseDTO;
import com.vmware.l10n.source.service.RemoteSyncService;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentSourceDTO;
import java.util.Map;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class RemoteSyncServicempl
implements RemoteSyncService {
    private static Logger logger = LoggerFactory.getLogger(RemoteSyncServicempl.class);
    @Autowired
    private SourceDao sourceDao;

    public void ping(String remoteURL) throws L10nAPIException {
        ComponentSourceDTO componentSourceDTO = new ComponentSourceDTO();
        componentSourceDTO.setProductName("test");
        componentSourceDTO.setVersion("test");
        componentSourceDTO.setLocale("test");
        componentSourceDTO.setComponent("test");
        componentSourceDTO.setComments("", "");
        componentSourceDTO.setMessages("", "");
        this.send(componentSourceDTO, remoteURL);
    }

    public void send(ComponentSourceDTO componentSourceDTO, String remoteURL) throws L10nAPIException {
        boolean pushFlag = false;
        if (!StringUtils.isEmpty((Object)componentSourceDTO)) {
            StringBuilder url = new StringBuilder();
            url.append(remoteURL).append("/api/v1/l10n/{productName}/{version}/{component}?locale={locale}".replace("{productName}", componentSourceDTO.getProductName()).replace("{version}", componentSourceDTO.getVersion()).replace("{component}", componentSourceDTO.getComponent()).replace("{locale}", "en"));
            JSONObject requestParam = new JSONObject();
            requestParam.put((Object)"messages", (Object)componentSourceDTO.getMessages());
            requestParam.put((Object)"comments", (Object)componentSourceDTO.getComments());
            requestParam.put((Object)"content_types", (Object)componentSourceDTO.getSourceFormats());
            pushFlag = this.sendToRemote(url.toString(), (Map)requestParam);
        }
        if (!pushFlag) {
            throw new L10nAPIException("Error occur when send to remote [" + remoteURL + "].");
        }
    }

    public boolean sendToRemote(String url, Map<String, Object> requestParam) {
        logger.info("Send data to remote server [{}] ...", (Object)url);
        logger.info("The request body is: {}", requestParam);
        boolean result = false;
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        JSONObject jsonObj = new JSONObject(requestParam);
        HttpEntity formEntity = new HttpEntity((Object)jsonObj.toString(), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)formEntity, GRMResponseDTO.class, new Object[0]);
            GRMResponseDTO gRMResponseDTO = (GRMResponseDTO)responseEntity.getBody();
            if (gRMResponseDTO == null) {
                return false;
            }
            if (gRMResponseDTO.getStatus() == GRMAPIResponseStatus.CREATED.getCode().intValue()) {
                result = true;
                logger.info("The request has succeeded, the result: {} {}", (Object)gRMResponseDTO.getStatus(), gRMResponseDTO.getResult());
            } else {
                logger.error("The request has failed, the response code: {} reason: {}", (Object)gRMResponseDTO.getStatus(), (Object)gRMResponseDTO.getErrorMessage());
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

