/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.dao.impl;

import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.vmware.l10n.conf.S3Cfg;
import com.vmware.l10n.conf.S3Client;
import com.vmware.l10n.record.model.RecordModel;
import com.vmware.l10n.source.dao.SourceDao;
import com.vmware.l10n.utils.SourceUtils;
import com.vmware.vip.common.constants.ConstantsFile;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.i18n.resourcefile.ResourceFilePathGetter;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.ComponentMessagesDTO;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
@Profile(value={"s3"})
public class S3SourceDaoImpl
implements SourceDao {
    private static Logger logger = LoggerFactory.getLogger(S3SourceDaoImpl.class);
    private static long deadLineTime = 32768L;
    @Autowired
    private S3Client s3Client;
    @Autowired
    private S3Cfg config;
    @Value(value="${source.bundle.file.basepath}")
    private String basePath;
    @Value(value="${source.sync.s3.compare.version.count:3}")
    private int compareVersionNum = 3;
    private ObjectWriter objectWriter = new ObjectMapper().writer(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).withDefaultPrettyPrinter();

    @PostConstruct
    private void init() {
        if (this.basePath.startsWith("/")) {
            this.basePath = this.basePath.substring(1);
        } else if (this.basePath.startsWith("./")) {
            this.basePath = this.basePath.replace(".", "").replace("/", "");
        }
        if (!this.basePath.isEmpty() && !this.basePath.endsWith("/")) {
            this.basePath = this.basePath + "/";
        }
        this.basePath = this.basePath + ConstantsFile.L10N_BUNDLES_PATH;
        this.basePath = this.basePath.replace("\\", "/");
    }

    public String getFromBundle(SingleComponentDTO componentMessagesDTO) {
        logger.debug("Read content from file: {}/{}", (Object)componentMessagesDTO.getLocale(), (Object)componentMessagesDTO.getComponent());
        String bundlePath = this.getBundleFilePath(this.basePath, componentMessagesDTO);
        return this.s3Client.readObject(bundlePath);
    }

    public boolean updateToBundle(ComponentMessagesDTO componentMessagesDTO) throws IOException {
        String bundlePath = this.getBundleFilePath(this.basePath, (SingleComponentDTO)componentMessagesDTO);
        ListVersionsRequest lvr = new ListVersionsRequest();
        lvr.setBucketName(this.config.getBucketName());
        lvr.setPrefix(bundlePath);
        lvr.setMaxResults(Integer.valueOf(this.compareVersionNum));
        long sleepTime = 512L;
        boolean flag = true;
        do {
            S3Object reqS3Obj = null;
            try {
                reqS3Obj = this.s3Client.getS3Client().getObject(this.config.getBucketName(), bundlePath);
            }
            catch (Exception ex) {
                logger.info("create new key:{}", (Object)bundlePath);
                reqS3Obj = null;
            }
            String sourceVersionId = null;
            String content = null;
            String updatedVersionId = null;
            if (reqS3Obj == null) {
                content = this.getOrderBundleJson((SingleComponentDTO)componentMessagesDTO);
                if (!this.s3Client.isObjectExist(bundlePath)) {
                    VersionListing versionListing;
                    String latestVersionId;
                    PutObjectResult putResult = this.s3Client.getS3Client().putObject(this.config.getBucketName(), bundlePath, content);
                    updatedVersionId = putResult.getVersionId();
                    if (updatedVersionId.equals(latestVersionId = ((S3VersionSummary)(versionListing = this.s3Client.getS3Client().listVersions(lvr)).getVersionSummaries().get(0)).getVersionId())) {
                        return true;
                    }
                    this.s3Client.getS3Client().deleteVersion(this.config.getBucketName(), bundlePath, updatedVersionId);
                    logger.warn("index 0, summarySize: {}, delete key: {},  no source version: {} ", new Object[]{versionListing.getVersionSummaries().size(), bundlePath, updatedVersionId});
                    logger.warn(content);
                }
            } else {
                sourceVersionId = reqS3Obj.getObjectMetadata().getVersionId();
                String existingBundle = null;
                try {
                    existingBundle = S3SourceDaoImpl.convertS3Obj2Str((S3Object)reqS3Obj);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
                SingleComponentDTO latestDTO = SourceUtils.mergeCacheWithBundle((SingleComponentDTO)componentMessagesDTO, (String)existingBundle);
                content = this.getOrderBundleJson(latestDTO);
                VersionListing sourceVersionListing = this.s3Client.getS3Client().listVersions(lvr);
                String preVersionId = ((S3VersionSummary)sourceVersionListing.getVersionSummaries().get(0)).getVersionId();
                if (sourceVersionId.equals(preVersionId)) {
                    PutObjectResult putResult = this.s3Client.getS3Client().putObject(this.config.getBucketName(), bundlePath, content);
                    updatedVersionId = putResult.getVersionId();
                    VersionListing updatedVersionListing = this.s3Client.getS3Client().listVersions(lvr);
                    List updateVersionSummary = updatedVersionListing.getVersionSummaries();
                    boolean isNotBreak = true;
                    for (int i = 0; i < updateVersionSummary.size(); ++i) {
                        if (i == 0) {
                            if (updatedVersionId.equals(((S3VersionSummary)updateVersionSummary.get(i)).getVersionId())) continue;
                            this.s3Client.getS3Client().deleteVersion(this.config.getBucketName(), bundlePath, updatedVersionId);
                            isNotBreak = false;
                            logger.warn("index{}, delete key: {},  no source version: {} ", new Object[]{i, bundlePath, updatedVersionId});
                            logger.warn(content);
                            break;
                        }
                        if (((S3VersionSummary)updateVersionSummary.get(i)).getVersionId().equals(((S3VersionSummary)sourceVersionListing.getVersionSummaries().get(i - 1)).getVersionId())) continue;
                        this.s3Client.getS3Client().deleteVersion(this.config.getBucketName(), bundlePath, updatedVersionId);
                        logger.warn("delete key: {},  no source version: {} ", (Object)bundlePath, (Object)updatedVersionId);
                        logger.warn("index{}, updated {}, source{}", new Object[]{i, ((S3VersionSummary)updateVersionSummary.get(i)).getVersionId(), ((S3VersionSummary)sourceVersionListing.getVersionSummaries().get(i - 1)).getVersionId()});
                        logger.warn(content);
                        isNotBreak = false;
                        break;
                    }
                    if (isNotBreak) {
                        return true;
                    }
                }
            }
            if (sleepTime > deadLineTime) {
                logger.warn("sleep Time {}", (Object)sleepTime);
                flag = false;
                continue;
            }
            try {
                logger.warn("sleep Time {}", (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
            sleepTime <<= 1;
        } while (flag);
        return false;
    }

    public List<RecordModel> getUpdateRecords(String productName, String version, long lastModifyTime) throws L10nAPIException {
        ListObjectsV2Result result;
        ArrayList<RecordModel> records = new ArrayList<RecordModel>();
        ListObjectsV2Request req = new ListObjectsV2Request().withBucketName(this.config.getBucketName());
        String latestJsonFile = "messages_latest.json";
        StringBuilder prefix = new StringBuilder();
        prefix.append(this.basePath);
        if (!StringUtils.isEmpty((CharSequence)productName)) {
            prefix.append(productName);
            prefix.append("/");
        }
        if (!StringUtils.isEmpty((CharSequence)version)) {
            prefix.append(version);
            prefix.append("/");
        }
        logger.info("begin getUpdateRecords lastModyTime: {}, prefix: {}", (Object)lastModifyTime, (Object)prefix.toString());
        req.setPrefix(prefix.toString());
        do {
            result = this.s3Client.getS3Client().listObjectsV2(req);
            for (S3ObjectSummary oSy : result.getObjectSummaries()) {
                String keyStr = oSy.getKey();
                long currentModifyTime = oSy.getLastModified().getTime();
                if (!keyStr.endsWith(latestJsonFile) || currentModifyTime <= lastModifyTime) continue;
                logger.info("Need Update:{}:{}", (Object)keyStr, (Object)currentModifyTime);
                records.add(SourceUtils.parseKeyStr2Record((String)keyStr, (String)this.basePath, (long)currentModifyTime));
            }
            String token = result.getNextContinuationToken();
            req.setContinuationToken(token);
        } while (result.isTruncated());
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertS3Obj2Str(S3Object s3Obj) throws IOException {
        S3ObjectInputStream s3is = s3Obj.getObjectContent();
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        byte[] read_buf = new byte[1024];
        int read_len = 0;
        try {
            while ((read_len = s3is.read(read_buf)) > 0) {
                fos.write(read_buf, 0, read_len);
            }
            String string = fos.toString("UTF-8");
            return string;
        }
        finally {
            s3is.close();
            fos.close();
        }
    }

    private String getBundleFilePath(String basePath, SingleComponentDTO dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getComponent())) {
            dto.setComponent("default");
        }
        return this.genProductVersionS3Path(basePath, dto.getProductName(), dto.getVersion()) + dto.getComponent() + "/" + ResourceFilePathGetter.getLocalizedJSONFileName((String)dto.getLocale());
    }

    private String genProductVersionS3Path(String basePath, String productName, String version) {
        StringBuilder path = new StringBuilder();
        path.append(basePath);
        path.append(productName);
        path.append("/");
        path.append(version);
        path.append("/");
        return path.toString();
    }

    private String getOrderBundleJson(SingleComponentDTO componentDTO) throws JsonProcessingException {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("component", componentDTO.getComponent());
        json.put("locale", componentDTO.getLocale());
        json.put("messages", componentDTO.getMessages());
        json.put("id", componentDTO.getId());
        return this.objectWriter.writeValueAsString(json);
    }
}

