/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.source.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.l10n.source.dto.SourceAPIResponseDTO;
import com.vmware.l10n.source.service.SourceService;
import com.vmware.l10n.utils.SourceUtils;
import com.vmware.vip.common.constants.ConstantsKeys;
import com.vmware.vip.common.exceptions.ValidationException;
import com.vmware.vip.common.i18n.dto.KeySourceCommentDTO;
import com.vmware.vip.common.i18n.status.APIResponseStatus;
import com.vmware.vip.common.i18n.status.Response;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import com.vmware.vip.common.l10n.source.dto.StringSourceDTO;
import com.vmware.vip.common.utils.RegExpValidatorUtils;
import com.vmware.vip.common.utils.SourceFormatUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="i10n-TranslationCollectKeyAPI")
public class TranslationCollectKeyAPI {
    private static Logger logger = LoggerFactory.getLogger(TranslationCollectKeyAPI.class);
    @Autowired
    private SourceService sourceService;

    @Hidden
    @Operation(summary="Post a key's source", description="Post a key's source under the component")
    @RequestMapping(value={"/i18n/l10n/api/v1/translation/string"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO collectV1StringTranslation(@Parameter(name="productName", required=true, description="product name") @RequestParam(value="productName", required=true) String productName, @Parameter(name="key", required=true, description="an id value to identify translation") @RequestParam(value="key", required=true) String key, @Parameter(name="version", required=true, description="translation version") @RequestParam(value="version", required=true) String version, @Parameter(name="component", required=true, description="component name") @RequestParam(value="component", required=true) String component, @Parameter(name="locale", description="locale String. e.g. 'en-US'") @RequestParam(value="locale", required=false) String locale, @Parameter(name="source", required=false, description="a source String needs to be translated") @RequestParam(value="source", required=false) String source, @Parameter(name="commentForSource", description="detailed comment to the source for better transaltion") @RequestParam(value="commentForSource", required=false) String commentForSource, @Parameter(name="sourceFormat", description="the format of source(used to identify the source's secial chars like html tags)") @RequestParam(value="sourceFormat", required=false) String sourceFormat, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws L10nAPIException {
        String newLocale = StringUtils.isEmpty((Object)locale) ? "en" : locale;
        String newSource = source == null ? "" : source;
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}, key={}, source={}", new Object[]{productName, version, component, locale, key, newSource});
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)newLocale, (String)key, (String)newSource, (String)commentForSource, (String)sourceFormat);
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }

    @Hidden
    @Operation(summary="Post the source", description="Post the source")
    @RequestMapping(value={"/i18n/l10n/api/v1/translation/product/{productName}/component/{component}/key/{key:.+}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO collectV1KeyTranslation(@PathVariable(value="productName") String productName, @Parameter(name="version", required=true, description="translation version") @RequestParam(value="version", required=true) String version, @PathVariable(value="component") String component, @PathVariable(value="key") String key, @Parameter(description="a source String needs to be translated", required=false) @RequestBody String source, @Parameter(name="commentForSource", description="detailed comment to the source for better transaltion") @RequestParam(value="commentForSource", required=false) String commentForSource, @Parameter(name="locale", description="locale String. e.g. 'en-US'") @RequestParam(value="locale", required=false) String locale, @Parameter(name="sourceFormat", description="the format of source(used to identify the source's secial chars like html tags)") @RequestParam(value="sourceFormat", required=false) String sourceFormat, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws L10nAPIException {
        String newLocale = locale == null ? "en" : locale;
        String querySource = request.getParameter("source");
        String newSource = "";
        if (!StringUtils.isEmpty((Object)source) || !StringUtils.isEmpty((Object)querySource)) {
            newSource = source == null ? querySource : source;
        }
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}, key={}, source={}", new Object[]{productName, version, component, locale, key, newSource});
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)newLocale, (String)key, (String)newSource, (String)commentForSource, (String)sourceFormat);
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }

    @Hidden
    @Operation(summary="Post a key's source", description="Post a key's source under the component")
    @RequestMapping(value={"/i18n/l10n/api/v1/translation/product/{productName}/key/{key:.+}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO collectV1KeyTranslationNoComponent(@Parameter(name="productName", required=true, description="product name") @PathVariable(value="productName") String productName, @Parameter(name="version", required=true, description="translation version") @RequestParam(value="version", required=true) String version, @Parameter(name="key", required=true, description="an id value to identify translation") @PathVariable(value="key") String key, @Parameter(name="source", required=false, description="a source String needs to be translated") @RequestParam(value="source", required=false) String source, @Parameter(name="commentForSource", description="detailed comment to the source for better transaltion") @RequestParam(value="commentForSource", required=false) String commentForSource, @Parameter(name="locale", description="locale String. e.g. 'en-US'") @RequestParam(value="locale", required=false) String locale, @Parameter(name="sourceFormat", description="the format of source(used to identify the source's secial chars like html tags)") @RequestParam(value="sourceFormat", required=false) String sourceFormat, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws L10nAPIException {
        String newLocale = locale == null ? "en" : locale;
        String newSource = source == null ? "" : source;
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)"default", (String)newLocale, (String)key, (String)newSource, (String)commentForSource, (String)sourceFormat);
        logger.info("The parameters are: productName={}, version={}, locale={}, key={}, source={}", new Object[]{productName, version, locale, key, newSource});
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }

    @Operation(summary="Post a source", description="Post a source under the component")
    @RequestMapping(value={"/i18n/l10n/api/v2/translation/products/{productName}/versions/{version}/locales/{locale}/components/{component}/keys/{key:.+}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO collectV2KeyTranslation(@Parameter(name="productName", required=true, description="product name") @PathVariable(value="productName") String productName, @Parameter(name="version", required=true, description="translation version") @PathVariable(value="version") String version, @Parameter(name="locale", required=true, description="locale String. e.g. 'en-US'") @PathVariable(value="locale") String locale, @Parameter(name="component", required=true, description="component name") @PathVariable(value="component") String component, @Parameter(name="key", required=true, description="an id value to identify translation") @PathVariable(value="key") String key, @Parameter(description="a source String needs to be translated", required=false) @RequestBody String source, @Parameter(name="commentForSource", description="detailed comment to the source for better transaltion") @RequestParam(value="commentForSource", required=false) String commentForSource, @Parameter(name="sourceFormat", description="the format of source(used to identify the source's secial chars like html tags)") @RequestParam(value="sourceFormat", required=false) String sourceFormat, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource) throws L10nAPIException {
        String newSource;
        String string = newSource = source == null ? "" : source;
        if (!StringUtils.isEmpty((Object)sourceFormat) && SourceFormatUtils.isBase64Encode((String)(sourceFormat = sourceFormat.toUpperCase()))) {
            newSource = SourceFormatUtils.decodeSourceBase64Str((String)newSource);
            sourceFormat = SourceFormatUtils.formatSourceFormatStr((String)sourceFormat);
        }
        StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)locale, (String)key, (String)newSource, (String)commentForSource, (String)sourceFormat);
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}, key={}, source={}", new Object[]{productName, version, component, locale, key, newSource});
        boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
        return SourceUtils.handleSourceResponse((boolean)isSourceCached);
    }

    @Operation(summary="Post a set of sources", description="Post a set of sources under the component")
    @RequestMapping(value={"/i18n/l10n/api/v2/translation/products/{productName}/versions/{version}/locales/{locale}/components/{component}/keys"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseStatus(value=HttpStatus.OK)
    public SourceAPIResponseDTO collectV2KeysTranslation(@Parameter(name="productName", required=true, description="product name") @PathVariable(value="productName") String productName, @Parameter(name="version", required=true, description="translation version") @PathVariable(value="version") String version, @Parameter(name="locale", required=true, description="locale String. e.g. 'en-US'") @PathVariable(value="locale") String locale, @Parameter(name="component", required=true, description="component name") @PathVariable(value="component") String component, @RequestBody List<KeySourceCommentDTO> sourceSet, @Parameter(name="collectSource", description="a flag to require backend collect the source for translation") @RequestParam(value="collectSource", required=true, defaultValue="true") String collectSource, HttpServletRequest request) throws ValidationException {
        logger.info("The parameters are: productName={}, version={}, component={}, locale={}", new Object[]{productName, version, component, locale});
        for (KeySourceCommentDTO sto : sourceSet) {
            String newLocale = locale == null ? "en" : locale;
            String newKey = sto.getKey();
            String newSource = sto.getSource();
            String sf = sto.getSourceFormat().toUpperCase();
            if (!StringUtils.isEmpty((Object)sf) && SourceFormatUtils.isBase64Encode((String)sf)) {
                newSource = SourceFormatUtils.decodeSourceBase64Str((String)newSource);
                sf = SourceFormatUtils.formatSourceFormatStr((String)sf);
            }
            if (!StringUtils.isEmpty((Object)sf) && !ConstantsKeys.SOURCE_FORMAT_LIST.contains(sf)) {
                throw new ValidationException(String.format("Incorrect source format '%s' for key '%s' (only allows empty, STRING, MD, HTML, SVG, BASE64)", newKey));
            }
            if (!RegExpValidatorUtils.isAscii((String)newKey)) {
                throw new ValidationException(String.format("Incorrect key name '%s' contains non-ASCII char(only allows standard ASCII char)", newKey));
            }
            StringSourceDTO sourceObj = SourceUtils.createSourceDTO((String)productName, (String)version, (String)component, (String)newLocale, (String)newKey, (String)newSource, (String)sto.getCommentForSource(), (String)sf);
            boolean isSourceCached = this.sourceService.cacheSource(sourceObj);
            if (isSourceCached) continue;
            return SourceUtils.handleSourceResponse((boolean)isSourceCached);
        }
        return SourceUtils.handleSourceResponse((boolean)true);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public void handleRequestBodyNull(HttpServletResponse resp) {
        Response respObj = new Response(APIResponseStatus.BAD_REQUEST.getCode(), "Don't support the key with NULL source");
        resp.setContentType("application/json;charset=utf-8");
        try {
            resp.getWriter().write(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)respObj));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

