/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.record.service;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.l10n.record.model.ComponentSourceModel;
import com.vmware.l10n.record.model.RecordModel;
import com.vmware.l10n.record.service.RecordService;
import com.vmware.l10n.source.dao.SourceDao;
import com.vmware.vip.common.i18n.dto.SingleComponentDTO;
import com.vmware.vip.common.l10n.exception.L10nAPIException;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RecordServiceImpl
implements RecordService {
    private static Logger logger = LoggerFactory.getLogger(RecordServiceImpl.class);
    private ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    @Autowired
    private SourceDao sourceDao;

    public ComponentSourceModel getComponentSource(String product, String version, String component, String locale) {
        SingleComponentDTO singleComponentDTO = new SingleComponentDTO();
        singleComponentDTO.setProductName(product);
        singleComponentDTO.setVersion(version);
        singleComponentDTO.setComponent(component);
        singleComponentDTO.setLocale(locale);
        String componentJSON = this.sourceDao.getFromBundle(singleComponentDTO);
        if (!StringUtils.isEmpty((Object)componentJSON)) {
            ComponentSourceModel source = null;
            try {
                source = (ComponentSourceModel)this.mapper.readValue(componentJSON, ComponentSourceModel.class);
                source.setProduct(product);
                source.setVersion(version);
                source.setComponent(component);
                source.setLocale(locale);
            }
            catch (JsonParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (JsonMappingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return source;
        }
        return null;
    }

    public List<RecordModel> getChangedRecords(String productName, String version, long lastModifyTime) throws L10nAPIException {
        return this.sourceDao.getUpdateRecords(productName, version, lastModifyTime);
    }
}

