/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.vmware.l10n.conf.CollectSourceReqBodyInterceptor;
import com.vmware.l10n.conf.CollectSourceValidationInterceptor;
import com.vmware.l10n.conf.CspAuthInterceptor;
import com.vmware.l10n.conf.CspValidateService;
import com.vmware.l10n.source.dao.AllowListDao;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@EnableWebMvc
public class WebConfiguration
implements WebMvcConfigurer {
    private static Logger logger = LoggerFactory.getLogger(WebConfiguration.class);
    @Value(value="${csp.api.auth.enable:false}")
    private String cspAuthFlag;
    @Value(value="${source.collect.request.max-size}")
    private Integer sourceCollectReqSize;
    @Value(value="${config.client.requestIds:}")
    private String requestIdsStr;
    @Autowired
    private CspValidateService cspValidateService;
    @Autowired
    private AllowListDao allowlistDao;

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.cspAuthFlag.equalsIgnoreCase("true")) {
            logger.info("add enable CSP authentication interceptor");
            registry.addInterceptor((HandlerInterceptor)new CspAuthInterceptor(this.cspValidateService)).addPathPatterns(new String[]{"/i18n/l10n/api/v2/translation/**", "/i18n/l10n/api/v1/translation/**"});
        }
        logger.info("add source collection validation interceptor");
        registry.addInterceptor((HandlerInterceptor)new CollectSourceValidationInterceptor(this.allowlistDao.getAllowList(), this.requestIdsStr)).addPathPatterns(new String[]{"/i18n/l10n/api/v2/translation/**", "/i18n/l10n/api/v1/translation/**"});
        registry.addInterceptor((HandlerInterceptor)new CollectSourceReqBodyInterceptor(this.sourceCollectReqSize.intValue())).addPathPatterns(new String[]{"/i18n/l10n/api/v2/translation/products/**"});
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        urlPathHelper.setUrlDecode(false);
        configurer.setUrlPathHelper(urlPathHelper);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"});
    }

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> tomcatCustomizer() {
        return factory -> factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            connector.setEncodedSolidusHandling(EncodedSolidusHandling.DECODE.getValue());
            connector.setAllowBackslash(true);
        }});
    }
}

