/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.l10n.conf;

import com.vmware.vip.common.exceptions.ValidationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;

public class CollectSourceReqBodyInterceptor
implements HandlerInterceptor {
    private int sourceReqBodySize = 0xA00000;

    public CollectSourceReqBodyInterceptor(int sourceReqSize) {
        if (sourceReqSize > 0) {
            this.sourceReqBodySize = sourceReqSize;
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getMethod().equalsIgnoreCase("POST") && Integer.valueOf(request.getHeader("content-length")) > this.sourceReqBodySize) {
            throw new ValidationException(String.format("Incorrect source collection request body (max size: %d bytes, current size: %s bytes)", this.sourceReqBodySize, request.getHeader("content-length")));
        }
        return true;
    }
}

