/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.io.IOException;
import java.util.Stack;

public class FormattingAppendableImpl
implements FormattingAppendable {
    private final Appendable myAppendable;
    private final Stack<ConditionalFrame> myConditionalFrames;
    private final Stack<Integer> myIndentLineCounts;
    private final char myEOL;
    private String myWhitespace;
    private String myWhitespaceEOL;
    private int myOptions;
    private IOException myIOException;
    private int myModCount;
    private int myOffsetBefore;
    private int myOffsetAfter;
    private int myPendingEOL;
    private boolean myPendingPreFormattedPrefix;
    private int myLineCount;
    private int myModCountOfLastEOL;
    private int myIndent;
    private boolean myWillIndent;
    private int myIndentOffset;
    private BasedSequence myPrefix;
    private BasedSequence myIndentPrefix;
    private int myPreFormattedNesting;
    private int myPendingSpaces;

    public FormattingAppendableImpl(Appendable appendable, boolean allFormatOptions) {
        this(appendable, allFormatOptions ? 7 : 0);
    }

    public FormattingAppendableImpl(Appendable appendable, int formatOptions) {
        this.myAppendable = appendable;
        this.myConditionalFrames = new Stack();
        this.myIndentLineCounts = new Stack();
        this.myEOL = (char)10;
        this.myOptions = formatOptions;
        this.myIOException = null;
        this.myModCount = 0;
        this.myOffsetBefore = 0;
        this.myOffsetAfter = 0;
        this.myPendingEOL = 0;
        this.myPendingPreFormattedPrefix = false;
        this.myLineCount = 0;
        this.myModCountOfLastEOL = 0;
        this.myIndent = 0;
        this.myWillIndent = false;
        this.myIndentOffset = 0;
        this.myPrefix = BasedSequence.NULL;
        this.myIndentPrefix = BasedSequence.NULL;
        this.myPreFormattedNesting = 0;
        this.setWhitespace();
    }

    private void setWhitespace() {
        this.myWhitespace = this.isConvertingTabs() ? " \t" : " ";
        this.myWhitespaceEOL = this.isConvertingTabs() ? " \t\r\n" : " \n";
    }

    @Override
    public int getOptions() {
        return this.myOptions;
    }

    @Override
    public FormattingAppendable setOptions(int options) {
        this.myOptions = options;
        this.setWhitespace();
        return this;
    }

    private boolean haveOptions(int options) {
        return (this.myOptions & options) != 0;
    }

    private boolean isConvertingTabs() {
        return this.haveOptions(3);
    }

    private boolean isSuppressingTrailingWhitespace() {
        return this.haveOptions(4);
    }

    private boolean isCollapseWhitespace() {
        return this.haveOptions(2);
    }

    private void appendIndent() throws IOException {
        if (!this.myPrefix.isEmpty()) {
            this.myAppendable.append(this.myPrefix);
            this.myOffsetAfter += this.myPrefix.length();
        }
        if (this.myIndent + this.myIndentOffset > 0 && !this.myIndentPrefix.isEmpty()) {
            for (int i = 0; i < this.myIndent + this.myIndentOffset; ++i) {
                this.myAppendable.append(this.myIndentPrefix);
                this.myOffsetAfter += this.myIndentPrefix.length();
            }
        }
    }

    private void addPendingSpaces(int count) {
        if (count > 0 && this.myPreFormattedNesting == 0 && this.myPendingEOL == 0 && this.myModCountOfLastEOL != this.myModCount) {
            if (this.isCollapseWhitespace()) {
                if (this.myPendingSpaces == 0) {
                    this.myPendingSpaces = 1;
                }
            } else {
                this.myPendingSpaces += count;
            }
        }
    }

    private void appendSpaces() throws IOException {
        if (this.myPendingSpaces > 0) {
            while (this.myPendingSpaces > 0) {
                this.myAppendable.append(' ');
                --this.myPendingSpaces;
                ++this.myOffsetAfter;
            }
            ++this.myModCount;
        }
    }

    private void setPendingEOL(int pendingEOL) {
        if (this.myPreFormattedNesting == 0 && this.myModCountOfLastEOL != this.myModCount && pendingEOL > this.myPendingEOL) {
            this.myPendingEOL = pendingEOL;
        }
    }

    private void resetPendingEOL() {
        this.myPendingEOL = 0;
        this.myPendingSpaces = 0;
        this.myModCountOfLastEOL = this.myModCount;
    }

    private void appendEOL(boolean withIndent, boolean withPendingSpaces) throws IOException {
        if (this.myPendingEOL > 0) {
            if (this.myPendingSpaces > 0 && !this.isSuppressingTrailingWhitespace()) {
                this.appendSpaces();
            }
            while (this.myPendingEOL > 0) {
                this.myAppendable.append(this.myEOL);
                ++this.myLineCount;
                --this.myPendingEOL;
                ++this.myOffsetAfter;
                if (this.myPendingEOL <= 0 || this.myPrefix.isEmpty()) continue;
                this.myAppendable.append(this.myPrefix);
                this.myOffsetAfter += this.myPrefix.length();
            }
            this.resetPendingEOL();
            if (withIndent) {
                this.appendIndent();
            }
        } else if (this.myModCountOfLastEOL == this.myModCount) {
            this.myPendingSpaces = 0;
            if (withIndent) {
                this.appendIndent();
            }
        } else if (withPendingSpaces) {
            this.appendSpaces();
        }
    }

    private void beforeAppendText(boolean withEOL, boolean withIndent, boolean withSpaces) throws IOException {
        if (this.myConditionalFrames.size() > 0) {
            ConditionalFrame frame = this.myConditionalFrames.peek();
            if (!frame.myInFormatter) {
                boolean firstApply;
                boolean bl = firstApply = frame.myModCount == this.myModCount;
                if (firstApply) {
                    ++this.myModCount;
                }
                if (firstApply || !frame.myOnIndent && (this.myWillIndent || frame.myIndent < this.myIndent)) {
                    frame.myInFormatter = true;
                    frame.myOnIndent = this.myWillIndent || frame.myIndent < this.myIndent;
                    frame.myOnLine = frame.myLineCount < this.myLineCount + this.myPendingEOL;
                    int indent = this.myIndent;
                    this.myIndent = frame.myIndent;
                    this.myPendingEOL = 0;
                    int lineCount = this.myLineCount;
                    frame.myOpenFormatter.apply(firstApply, frame.myOnIndent, frame.myOnLine, true);
                    this.myIndent += indent - frame.myIndent;
                    if (frame.myLineRef != null && firstApply) {
                        frame.myLineRef.value = lineCount != this.myLineCount;
                    }
                    frame.myInFormatter = false;
                }
            }
        }
        if (withEOL) {
            this.appendEOL(withIndent, withSpaces);
        } else if (withSpaces) {
            this.appendSpaces();
        }
    }

    private void appendImpl(char c) throws IOException {
        if (this.myPreFormattedNesting > 0) {
            this.myOffsetBefore = this.myOffsetAfter;
            if (this.myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                this.myAppendable.append(this.myPrefix);
                this.myOffsetAfter += this.myPrefix.length();
            }
            this.myPendingPreFormattedPrefix = false;
            this.myAppendable.append(c);
            ++this.myOffsetAfter;
            ++this.myModCount;
            if (c == this.myEOL) {
                ++this.myLineCount;
                this.myPendingPreFormattedPrefix = true;
            }
            this.resetPendingEOL();
        } else if (c == this.myEOL) {
            this.setPendingEOL(1);
        } else if (this.myWhitespace.indexOf(c) != -1) {
            this.addPendingSpaces(1);
        } else {
            this.beforeAppendText(true, true, true);
            this.myOffsetBefore = this.myOffsetAfter++;
            this.myAppendable.append(c);
            ++this.myModCount;
        }
    }

    private void appendImpl(CharSequence csq, int start, int end) throws IOException {
        int lastPos = start;
        BasedSequence seq = BasedSequenceImpl.of(csq);
        if (this.myPreFormattedNesting > 0) {
            this.myOffsetBefore = this.myOffsetAfter;
            while (lastPos < end) {
                int endPos;
                int pos = seq.indexOf(this.myEOL, lastPos, end);
                int n = endPos = pos == -1 ? csq.length() : pos + 1;
                if (lastPos < endPos) {
                    if (this.myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                        this.myAppendable.append(this.myPrefix);
                        this.myOffsetAfter += this.myPrefix.length();
                    }
                    this.myPendingPreFormattedPrefix = false;
                    this.myAppendable.append(csq, lastPos, endPos);
                    this.myOffsetAfter += endPos - lastPos;
                }
                if (pos == -1) break;
                ++this.myLineCount;
                this.myPendingPreFormattedPrefix = true;
                lastPos = endPos;
            }
            ++this.myModCount;
            if (lastPos == end) {
                this.resetPendingEOL();
            }
        } else {
            boolean firstAppend = true;
            while (lastPos < end) {
                int spanEnd;
                int pos = seq.indexOfAny(this.myWhitespaceEOL, lastPos, end);
                int n = spanEnd = pos == -1 ? end : pos;
                if (lastPos < spanEnd) {
                    this.beforeAppendText(true, true, true);
                    if (firstAppend) {
                        this.myOffsetBefore = this.myOffsetAfter;
                        firstAppend = false;
                    }
                    this.myAppendable.append(csq, lastPos, spanEnd);
                    ++this.myModCount;
                    this.myOffsetAfter += spanEnd - lastPos;
                }
                if (pos == -1) break;
                int span = seq.countChars(this.myWhitespaceEOL, pos, end);
                if (this.myPendingEOL == 0) {
                    if (seq.indexOf(this.myEOL, pos, pos + span) != -1) {
                        this.setPendingEOL(1);
                    } else {
                        this.addPendingSpaces(span);
                    }
                }
                lastPos = pos += span;
            }
        }
    }

    @Override
    public IOException getIOException() {
        return this.myIOException;
    }

    private void setIOException(IOException e) {
        if (this.myIOException == null) {
            this.myIOException = e;
        }
    }

    @Override
    public FormattingAppendable append(CharSequence csq) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(csq, 0, csq.length());
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable append(CharSequence csq, int start, int end) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(csq, start, end);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable append(char c) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(c);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable flush() {
        return this.flush(0);
    }

    @Override
    public FormattingAppendable flush(int maxBlankLines) {
        int blankLines;
        assert (this.myConditionalFrames.size() == 0);
        assert (this.myPreFormattedNesting == 0);
        this.setPendingEOL(1);
        int n = blankLines = maxBlankLines >= 0 ? maxBlankLines : 0;
        if (this.myPendingEOL > blankLines + 1) {
            this.myPendingEOL = maxBlankLines + 1;
        }
        try {
            if (this.myIOException == null) {
                this.myOffsetBefore = this.myOffsetAfter;
                this.appendEOL(false, false);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myIndentPrefix;
    }

    @Override
    public FormattingAppendable setIndentPrefix(CharSequence prefix) {
        this.myIndentPrefix = CharSubSequence.of(prefix);
        return this;
    }

    @Override
    public BasedSequence getPrefix() {
        return this.myPrefix;
    }

    @Override
    public CharSequence getTotalIndentPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(RepeatedCharSequence.of(this.myIndentPrefix, this.myIndent));
        return sb.toString();
    }

    @Override
    public FormattingAppendable setPrefix(CharSequence prefix) {
        this.myPrefix = CharSubSequence.of(prefix);
        return this;
    }

    @Override
    public FormattingAppendable line() {
        this.setPendingEOL(1);
        return this;
    }

    @Override
    public FormattingAppendable lineIf(boolean predicate) {
        if (predicate) {
            this.line();
        }
        return this;
    }

    @Override
    public FormattingAppendable line(Ref<Boolean> lineRef) {
        lineRef.value = true;
        if (this.myConditionalFrames.size() > 0) {
            ConditionalFrame frame = this.myConditionalFrames.peek();
            if (frame.myModCount == this.myModCount) {
                if (frame.myLineRef != null) {
                    frame.myLineRef.value = false;
                }
                frame.myLineRef = lineRef;
            }
        }
        this.setPendingEOL(1);
        return this;
    }

    @Override
    public FormattingAppendable lineIf(Ref<Boolean> lineRef) {
        if (((Boolean)lineRef.value).booleanValue()) {
            this.line();
        }
        return this;
    }

    @Override
    public FormattingAppendable blankLine() {
        this.setPendingEOL(2);
        return this;
    }

    @Override
    public FormattingAppendable blankLineIf(boolean predicate) {
        if (predicate) {
            this.blankLine();
        }
        return this;
    }

    @Override
    public FormattingAppendable blankLine(int count) {
        if (count > 0) {
            this.setPendingEOL(count + 1);
        }
        return this;
    }

    @Override
    public int getIndent() {
        return this.myIndent + this.myIndentOffset;
    }

    @Override
    public FormattingAppendable setIndentOffset(int indentOffset) {
        this.myIndentOffset = indentOffset;
        return this;
    }

    @Override
    public FormattingAppendable indent() {
        if (this.myPreFormattedNesting != 0) {
            throw new IllegalStateException("indent should not be called inside preFormatted");
        }
        this.line();
        ++this.myIndent;
        this.myIndentLineCounts.push(this.myLineCount);
        this.myWillIndent = false;
        return this;
    }

    @Override
    public FormattingAppendable willIndent() {
        this.myWillIndent = true;
        return this;
    }

    @Override
    public FormattingAppendable unIndent() {
        if (this.myIndent <= 0) {
            throw new IllegalStateException("unIndent called with nesting == 0");
        }
        if (this.myPreFormattedNesting != 0) {
            throw new IllegalStateException("unIndent should not be called inside preFormatted");
        }
        int indentLineCount = this.myIndentLineCounts.pop();
        if (indentLineCount == this.myLineCount) {
            this.myPendingEOL = 0;
        } else {
            this.line();
        }
        --this.myIndent;
        return this;
    }

    @Override
    public int getModCount() {
        return this.myModCount;
    }

    @Override
    public int getLineCount() {
        return this.myLineCount;
    }

    @Override
    public int getOffsetBefore() {
        return this.myOffsetBefore;
    }

    @Override
    public int getOffsetAfter() {
        return this.myOffsetAfter;
    }

    @Override
    public FormattingAppendable openPreFormatted(boolean keepIndent) {
        try {
            this.myOffsetBefore = this.myOffsetAfter;
            if (!keepIndent) {
                this.myPendingPreFormattedPrefix = this.myPendingEOL > 0;
            }
            this.beforeAppendText(true, keepIndent, keepIndent);
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        this.myPendingSpaces = 0;
        this.myPendingEOL = 0;
        ++this.myPreFormattedNesting;
        return this;
    }

    @Override
    public FormattingAppendable closePreFormatted() {
        if (this.myPreFormattedNesting <= 0) {
            throw new IllegalStateException("closePreFormatted called with nesting == 0");
        }
        this.myPendingPreFormattedPrefix = false;
        --this.myPreFormattedNesting;
        return this;
    }

    @Override
    public boolean isPreFormatted() {
        return this.myPreFormattedNesting > 0;
    }

    @Override
    public FormattingAppendable openConditional(ConditionalFormatter openFormatter) {
        ConditionalFrame frame = new ConditionalFrame(openFormatter, this.myModCount, this.myIndent, this.myLineCount);
        this.myConditionalFrames.push(frame);
        return this;
    }

    @Override
    public FormattingAppendable closeConditional(ConditionalFormatter closeFormatter) {
        if (this.myConditionalFrames.size() == 0) {
            throw new IllegalStateException("closeConditional called with no conditionals open");
        }
        ConditionalFrame frame = this.myConditionalFrames.pop();
        closeFormatter.apply(true, frame.myOnIndent, frame.myOnLine, frame.myModCount != this.myModCount);
        return this;
    }

    private static class ConditionalFrame {
        final ConditionalFormatter myOpenFormatter;
        final int myModCount;
        final int myIndent;
        final int myLineCount;
        Ref<Boolean> myLineRef;
        boolean myOnIndent;
        boolean myOnLine;
        boolean myInFormatter;

        ConditionalFrame(ConditionalFormatter openFormatter, int modCount, int indent, int lineCount) {
            this.myOpenFormatter = openFormatter;
            this.myModCount = modCount;
            this.myIndent = indent;
            this.myLineCount = lineCount;
            this.myLineRef = null;
            this.myOnIndent = false;
            this.myOnLine = false;
            this.myInFormatter = false;
        }
    }
}

