/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class MappedSequence
extends SubSequence {
    protected final CharMapper mapper;

    public CharMapper getCharMapper() {
        return this.mapper;
    }

    public MappedSequence(CharSequence baseSeq, CharMapper mapper) {
        super(baseSeq);
        this.mapper = mapper;
    }

    public MappedSequence(SubSequence baseSeq, int start, int end, CharMapper mapper) {
        super(baseSeq, start, end);
        this.mapper = mapper;
    }

    public MappedSequence(CharSequence baseSeq, int startOffset, int endOffset, CharMapper mapper) {
        super(baseSeq, startOffset, endOffset);
        this.mapper = mapper;
    }

    @Override
    public char charAt(int index) {
        char c = super.charAt(index);
        return this.mapper.map(c);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        return new MappedSequence(this.base, this.startOffset + start, this.startOffset + end, this.mapper);
    }

    @Override
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.mapper.map(super.charAt(i)));
        }
        return sb.toString();
    }
}

