/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterable;
import com.vladsch.flexmark.util.collection.iteration.BitSetIterator;
import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrderedSet<E>
implements Set<E>,
Iterable<E> {
    private final HashMap<E, Integer> myKeyMap;
    private final ArrayList<E> myValueList;
    private final CollectionHost<E> myHost;
    private Indexed<E> myIndexedProxy;
    private Indexed<E> myAllowConcurrentModsIndexedProxy;
    private BitSet myValidIndices;
    private int myModificationCount;

    public OrderedSet() {
        this(0);
    }

    public OrderedSet(int capacity) {
        this(capacity, null);
    }

    public OrderedSet(CollectionHost<E> host) {
        this(0, host);
    }

    public OrderedSet(int capacity, CollectionHost<E> host) {
        this.myKeyMap = new HashMap(capacity);
        this.myValueList = new ArrayList(capacity);
        this.myValidIndices = new BitSet();
        this.myHost = host;
        this.myModificationCount = Integer.MIN_VALUE;
        this.myIndexedProxy = null;
        this.myAllowConcurrentModsIndexedProxy = null;
    }

    public BitSet indexBitSet(Iterable<? extends E> items) {
        BitSet bitSet = new BitSet();
        for (E element : items) {
            int i = this.indexOf(element);
            if (i == -1) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public BitSet differenceBitSet(Iterable<? extends E> items) {
        return this.differenceBitSet(items.iterator());
    }

    public BitSet differenceBitSet(Iterator<? extends E> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            E element = items.next();
            int i = this.indexOf(element);
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    public BitSet keyDifferenceBitSet(Iterable<? extends Map.Entry<? extends E, ?>> items) {
        return this.keyDifferenceBitSet(items.iterator());
    }

    public BitSet keyDifferenceBitSet(Iterator<? extends Map.Entry<? extends E, ?>> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            Map.Entry<E, ?> entry = items.next();
            int i = this.indexOf(entry.getKey());
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    public BitSet valueDifferenceBitSet(Iterable<? extends Map.Entry<?, ? extends E>> items) {
        return this.valueDifferenceBitSet(items.iterator());
    }

    public BitSet valueDifferenceBitSet(Iterator<? extends Map.Entry<?, ? extends E>> items) {
        BitSet bitSet = new BitSet();
        int j = 0;
        while (items.hasNext()) {
            Map.Entry<?, E> entry = items.next();
            int i = this.indexOf(entry.getValue());
            if (i != j) {
                bitSet.set(i);
            }
            ++j;
        }
        return bitSet;
    }

    public Indexed<E> getIndexedProxy() {
        if (this.myIndexedProxy != null) {
            return this.myIndexedProxy;
        }
        this.myIndexedProxy = new IndexedProxy(false);
        return this.myIndexedProxy;
    }

    public Indexed<E> getConcurrentModsIndexedProxy() {
        if (this.myAllowConcurrentModsIndexedProxy != null) {
            return this.myAllowConcurrentModsIndexedProxy;
        }
        this.myAllowConcurrentModsIndexedProxy = new IndexedProxy(true);
        return this.myAllowConcurrentModsIndexedProxy;
    }

    public int getModificationCount() {
        return this.myModificationCount;
    }

    private int getIteratorModificationCount() {
        return this.myHost != null ? this.myHost.getIteratorModificationCount() : this.myModificationCount;
    }

    public static <T1> T1 ifNull(T1 o, T1 nullValue) {
        return o == null ? nullValue : o;
    }

    public boolean inHostUpdate() {
        return this.myHost != null && this.myHost.skipHostUpdate();
    }

    public int indexOf(Object element) {
        return OrderedSet.ifNull(this.myKeyMap.get(element), -1);
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.myValueList.size() && this.myValidIndices.get(index);
    }

    public void validateIndex(int index) {
        if (!this.isValidIndex(index)) {
            throw new IndexOutOfBoundsException("Index " + index + " is not valid, size=" + this.myValueList.size() + " validIndices[" + index + "]=" + this.myValidIndices.get(index));
        }
    }

    public E getValue(int index) {
        this.validateIndex(index);
        return this.myValueList.get(index);
    }

    public E getValueOrNull(int index) {
        return this.isValidIndex(index) ? (E)this.myValueList.get(index) : null;
    }

    @Override
    public int size() {
        return this.myKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myKeyMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myKeyMap.containsKey(o);
    }

    public List<E> getValueList() {
        return this.myValueList;
    }

    public List<E> values() {
        if (!this.isSparse()) {
            return this.myValueList;
        }
        ArrayList list = new ArrayList();
        for (Object item : this.iterable()) {
            list.add(item);
        }
        return list;
    }

    public boolean setValueAt(int index, E value, Object o) {
        int indexOf = this.indexOf(value);
        if (indexOf != -1) {
            if (index != indexOf) {
                throw new IllegalStateException("Trying to add existing element " + value + "[" + indexOf + "] at index " + index);
            }
            return false;
        }
        if (index < this.myValueList.size()) {
            if (this.myValidIndices.get(index)) {
                throw new IllegalStateException("Trying to add new element " + value + " at index " + index + ", already occupied by " + this.myValueList.get(index));
            }
        } else if (index > this.myValueList.size()) {
            this.addNulls(index - 1);
        }
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.adding(index, value, o);
        }
        this.myKeyMap.put(value, index);
        this.myValueList.set(index, value);
        this.myValidIndices.set(index);
        return true;
    }

    public boolean isSparse() {
        return this.myValidIndices.nextClearBit(0) < this.myValueList.size();
    }

    public void addNull() {
        this.addNulls(this.myValueList.size());
    }

    public void addNulls(int index) {
        assert (index >= this.myValueList.size());
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.addingNulls(index);
        }
        int start = this.myValueList.size();
        ++this.myModificationCount;
        while (this.myValueList.size() <= index) {
            this.myValueList.add(null);
        }
    }

    public ReversibleIterator<Integer> indexIterator() {
        return new BitSetIterator(this.myValidIndices);
    }

    public ReversibleIterator<Integer> reversedIndexIterator() {
        return new BitSetIterator(this.myValidIndices, true);
    }

    public ReversibleIterable<Integer> indexIterable() {
        return new BitSetIterable(this.myValidIndices);
    }

    public ReversibleIterable<Integer> reversedIndexIterable() {
        return new BitSetIterable(this.myValidIndices, true);
    }

    @Override
    public ReversibleIndexedIterator<E> iterator() {
        return new IndexedIterator(this.getIndexedProxy(), this.indexIterator());
    }

    public ReversibleIndexedIterator<E> reversedIterator() {
        return new IndexedIterator(this.getIndexedProxy(), this.reversedIndexIterator());
    }

    public ReversibleIterable<E> iterable() {
        return new IndexedIterable(this.getIndexedProxy(), this.indexIterable());
    }

    public ReversibleIterable<E> reversedIterable() {
        return new IndexedIterable(this.getIndexedProxy(), this.reversedIndexIterable());
    }

    @Override
    public Object[] toArray() {
        Object[] objects = new Object[this.myKeyMap.size()];
        int index = -1;
        int i = -1;
        while (index + 1 < this.myValueList.size()) {
            if (!this.myValidIndices.get(++index)) continue;
            objects[++i] = this.myValueList.get(index);
        }
        return objects;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] objects = array;
        if (array.length < this.myKeyMap.size()) {
            objects = array.getClass() == Object[].class ? new Object[this.myKeyMap.size()] : (Object[])Array.newInstance(array.getClass().getComponentType(), this.myKeyMap.size());
        }
        int index = -1;
        int i = -1;
        while (index + 1 < this.myValueList.size()) {
            if (!this.myValidIndices.get(++index)) continue;
            objects[++i] = this.myValueList.get(index);
        }
        if (objects.length > ++i) {
            objects[i] = null;
        }
        return objects;
    }

    @Override
    public boolean add(E e) {
        return this.add(e, null);
    }

    public boolean add(E e, Object o) {
        if (this.myKeyMap.containsKey(e)) {
            return false;
        }
        int i = this.myValueList.size();
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.adding(i, e, o);
        }
        ++this.myModificationCount;
        this.myKeyMap.put(e, i);
        this.myValueList.add(e);
        this.myValidIndices.set(i);
        return true;
    }

    public boolean removeIndex(int index) {
        return this.removeIndexHosted(index) != null;
    }

    public Object removeIndexHosted(int index) {
        this.validateIndex(index);
        E o = this.myValueList.get(index);
        Object r = null;
        r = this.myHost != null && !this.myHost.skipHostUpdate() ? this.myHost.removing(index, o) : (Object)o;
        ++this.myModificationCount;
        this.myKeyMap.remove(o);
        if (this.myKeyMap.size() == 0) {
            if (this.myHost != null && !this.myHost.skipHostUpdate()) {
                this.myHost.clearing();
            }
            this.myValueList.clear();
            this.myValidIndices.clear();
        } else {
            if (this.myHost == null && index == this.myValueList.size() - 1) {
                this.myValueList.remove(index);
            }
            this.myValidIndices.clear(index);
        }
        return r;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeHosted(o) != null;
    }

    public Object removeHosted(Object o) {
        Integer index = this.myKeyMap.get(o);
        if (index == null) {
            return null;
        }
        return this.removeIndexHosted(index);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.myKeyMap.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean[] changed = new boolean[]{false};
        for (E e : collection) {
            if (!this.add(e)) continue;
            changed[0] = true;
        }
        return changed[0];
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        BitSet removeSet = new BitSet(this.myValueList.size());
        removeSet.set(0, this.myValueList.size());
        removeSet.and(this.myValidIndices);
        for (Object o : collection) {
            int index = this.indexOf(o);
            if (index == -1) continue;
            removeSet.clear(index);
        }
        int index = this.myValueList.size();
        if (index == 0) {
            return false;
        }
        boolean changed = false;
        while (index-- > 0 && (index = removeSet.previousSetBit(index)) != -1) {
            this.remove(this.myValueList.get(index));
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object o : collection) {
            if (!this.myKeyMap.containsKey(o) || !this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        if (this.myHost != null && !this.myHost.skipHostUpdate()) {
            this.myHost.clearing();
        }
        ++this.myModificationCount;
        this.myKeyMap.clear();
        this.myValueList.clear();
        this.myValidIndices.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedSet set = (OrderedSet)o;
        if (this.size() != set.size()) {
            return false;
        }
        Iterator setIterator = set.iterator();
        for (Object e : this) {
            Object eSet;
            if (e.equals(eSet = setIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.myKeyMap.hashCode();
        result = 31 * result + this.myValueList.hashCode();
        result = 31 * result + this.myValidIndices.hashCode();
        return result;
    }

    public BitSet getValidIndices() {
        return this.myValidIndices;
    }

    private class IndexedProxy
    implements Indexed<E> {
        private final boolean myAllowConcurrentMods;

        public IndexedProxy(boolean allowConcurrentMods) {
            this.myAllowConcurrentMods = allowConcurrentMods;
        }

        @Override
        public E get(int index) {
            return OrderedSet.this.getValue(index);
        }

        @Override
        public void set(int index, E item) {
            OrderedSet.this.setValueAt(index, item, null);
        }

        @Override
        public void removeAt(int index) {
            OrderedSet.this.removeIndexHosted(index);
        }

        @Override
        public int size() {
            return OrderedSet.this.myValueList.size();
        }

        @Override
        public int modificationCount() {
            return this.myAllowConcurrentMods ? 0 : OrderedSet.this.getIteratorModificationCount();
        }
    }
}

