/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.StringSequence;
import com.vladsch.flexmark.util.sequence.Substring;
import java.util.ArrayList;
import java.util.List;

public class SubSequence
extends BasedSequenceImpl {
    public static final BasedSequence NULL = new EmptyBasedSequence();
    public static final BasedSequence EOL = new StringSequence("\n");
    public static final List<BasedSequence> EMPTY_LIST = new ArrayList<BasedSequence>();
    public static final BasedSequence[] EMPTY_ARRAY = new BasedSequence[0];
    protected final CharSequence base;
    protected final int startOffset;
    protected final int endOffset;

    public static BasedSequence firstNonNull(BasedSequence ... sequences) {
        for (BasedSequence sequence : sequences) {
            if (sequence == null || sequence == NULL) continue;
            return sequence;
        }
        return NULL;
    }

    @Override
    public CharSequence getBase() {
        return this.base;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public SubSequence(CharSequence base) {
        this(base, 0, base.length());
    }

    public SubSequence(CharSequence base, int startOffset, int endOffset) {
        if (startOffset < 0) {
            throw new StringIndexOutOfBoundsException("beginIndex:" + startOffset + " must be at least 0");
        }
        if (endOffset < 0) {
            throw new StringIndexOutOfBoundsException("endIndex:" + endOffset + " must be at least 0");
        }
        if (endOffset < startOffset) {
            throw new StringIndexOutOfBoundsException("endIndex:" + endOffset + " must not be less than beginIndex:" + startOffset);
        }
        if (endOffset > base.length()) {
            throw new StringIndexOutOfBoundsException("endIndex:" + endOffset + " must not be greater than length");
        }
        this.base = base;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < 0 || this.startOffset + index > this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        return this.startOffset + index;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || this.startOffset + index >= this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        char c = this.base.charAt(index + this.startOffset);
        return c == '\u0000' ? (char)'\ufffd' : (char)c;
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + start + " out of range: 0, " + this.length());
        }
        if (end < 0 || this.startOffset + end > this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + end + " out of range: 0, " + this.length());
        }
        return new SubSequence(this.base, this.startOffset + start, this.startOffset + end);
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index: " + start + " out of range: 0, " + this.length());
        }
        if (end < 0 || end > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index: " + end + " out of range: 0, " + this.length());
        }
        return new SubSequence(this.base, start, end);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    private static class EmptyBasedSequence
    extends BasedSequenceImpl {
        private EmptyBasedSequence() {
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }

        @Override
        public int getIndexOffset(int index) {
            if (index == 0) {
                return 0;
            }
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }

        @Override
        public BasedSequence subSequence(int i, int i1) {
            if (i == 0 && i1 == 0) {
                return this;
            }
            throw new StringIndexOutOfBoundsException("EMPTY subSequence(" + i + "," + i1 + ") only subSequence(0, 0) is allowed");
        }

        @Override
        public BasedSequence baseSubSequence(int start, int end) {
            return this.subSequence(start, end);
        }

        @Override
        public CharSequence getBase() {
            return Substring.EMPTY;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 0;
        }

        @Override
        public Range getSourceRange() {
            return Range.NULL;
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

