/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class MappedSequence
extends SubSequence {
    protected final CharMapper mapper;

    public CharMapper getCharMapper() {
        return this.mapper;
    }

    public MappedSequence(CharSequence base, CharMapper mapper) {
        this(base, 0, base.length(), mapper);
    }

    public MappedSequence(CharSequence base, int startOffset, int endOffset, CharMapper mapper) {
        super(base, startOffset, endOffset);
        this.mapper = mapper;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || this.startOffset + index >= this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        char c = this.base.charAt(index + this.startOffset);
        return this.mapper.map(c);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + start + " out of range: 0, " + this.length());
        }
        if (end < 0 || this.startOffset + end > this.endOffset) {
            throw new StringIndexOutOfBoundsException("String index: " + end + " out of range: 0, " + this.length());
        }
        return new MappedSequence(this.base, this.startOffset + start, this.startOffset + end, this.mapper);
    }

    @Override
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.mapper.map(this.base.charAt(i + this.startOffset)));
        }
        return sb.toString();
    }
}

