/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Attribute {
    public static final Attribute NO_FOLLOW = new Attribute("rel", "nofollow");
    public static final Set<String> NON_RENDERING_WHEN_EMPTY = new HashSet<String>(Arrays.asList("class", "id", "name"));
    public static final String LINK_STATUS = "Link Status";
    private final String myName;
    private final String myValue;

    public Attribute(String name, String value) {
        this.myName = name;
        this.myValue = value;
    }

    public String getName() {
        return this.myName;
    }

    public String getValue() {
        return this.myValue;
    }

    protected int indexOfValue(String value) {
        int pos;
        if (value.isEmpty() || this.myValue.isEmpty()) {
            return -1;
        }
        int lastPos = 0;
        while (lastPos < this.myValue.length() && (pos = this.myValue.indexOf(value, lastPos)) != -1) {
            int endPos = pos + value.length();
            if (!(pos != 0 && this.myValue.charAt(pos - 1) != ' ' || endPos < this.myValue.length() && this.myValue.charAt(endPos) != ' ')) {
                return pos;
            }
            lastPos = endPos + 1;
        }
        return -1;
    }

    public boolean isNonRendering() {
        return this.myName.indexOf(32) != -1 || this.myValue.isEmpty() && NON_RENDERING_WHEN_EMPTY.contains(this.myName);
    }

    public Attribute replaceValue(String value) {
        if (this.myValue.equals(value)) {
            return this;
        }
        return new Attribute(this.myName, value);
    }

    public Attribute addValue(String value) {
        if (value.isEmpty() || this.indexOfValue(value) >= 0) {
            return this;
        }
        return new Attribute(this.myName, this.myValue.isEmpty() ? value : this.myValue + " " + value);
    }

    public Attribute removeValue(String value) {
        int pos = this.indexOfValue(value);
        if (pos >= 0) {
            int endPos = pos + value.length();
            if (endPos >= this.myValue.length()) {
                if (pos > 0) {
                    --pos;
                }
                return new Attribute(this.myName, this.myValue.substring(0, pos));
            }
            if (pos == 0) {
                if (endPos < this.myValue.length()) {
                    ++endPos;
                }
                return new Attribute(this.myName, this.myValue.substring(endPos));
            }
            return new Attribute(this.myName, this.myValue.substring(0, pos - 1) + this.myValue.substring(endPos));
        }
        return this;
    }

    public boolean containsValue(String value) {
        return this.indexOfValue(value) != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.myName.equals(attribute.myName)) {
            return false;
        }
        return this.myValue.equals(attribute.myValue);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }
}

