/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.BiFunction;
import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.collection.MaxAggregator;
import com.vladsch.flexmark.util.collection.MinAggregator;
import com.vladsch.flexmark.util.format.TableCaptionSection;
import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.format.TableCellOffsetInfo;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TableRow;
import com.vladsch.flexmark.util.format.TableRowManipulator;
import com.vladsch.flexmark.util.format.TableSection;
import com.vladsch.flexmark.util.format.TableSectionType;
import com.vladsch.flexmark.util.format.TableSeparatorSection;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarkdownTable {
    public final TableSection header;
    public final TableSection separator;
    public final TableSection body;
    public final TableSection caption;
    public TableFormatOptions options;
    private boolean isHeading = true;
    private boolean isSeparator = false;
    private CellAlignment[] alignments;
    private int[] columnWidths;
    private HashMap<Integer, Integer> trackedOffsets = new HashMap();
    private final TableSection[] ALL_SECTIONS;
    private final TableSection[] ALL_TABLE_ROWS;
    private final TableSection[] ALL_CONTENT_ROWS;

    public MarkdownTable(DataHolder options) {
        this(new TableFormatOptions(options));
    }

    public MarkdownTable(TableFormatOptions options) {
        this.header = new TableSection(TableSectionType.HEADER);
        this.separator = new TableSeparatorSection(TableSectionType.SEPARATOR);
        this.body = new TableSection(TableSectionType.BODY);
        this.caption = new TableCaptionSection(TableSectionType.CAPTION);
        this.options = options == null ? new TableFormatOptions(null) : options;
        this.ALL_SECTIONS = new TableSection[]{this.header, this.separator, this.body, this.caption};
        this.ALL_TABLE_ROWS = new TableSection[]{this.header, this.separator, this.body};
        this.ALL_CONTENT_ROWS = new TableSection[]{this.header, this.body};
    }

    public TableCell getCaptionCell() {
        return this.caption.rows.size() > 0 && this.caption.rows.get((int)0).cells.size() > 0 ? this.caption.rows.get((int)0).cells.get(0) : TableCaptionSection.NULL_CELL;
    }

    public void setCaptionCell(TableCell captionCell) {
        if (this.caption.rows.size() == 0) {
            this.caption.rows.add(this.caption.defaultRow());
        }
        this.caption.rows.get((int)0).cells.clear();
        this.caption.rows.get((int)0).cells.add(captionCell);
    }

    public BasedSequence getCaption() {
        return this.getCaptionCell().text;
    }

    public void setCaption(CharSequence caption) {
        TableCell captionCell = this.getCaptionCell();
        this.setCaptionCell(captionCell.withText(captionCell.openMarker.isEmpty() ? "[" : captionCell.openMarker, caption, captionCell.closeMarker.isEmpty() ? "]" : captionCell.closeMarker));
    }

    public void setCaptionWithMarkers(CharSequence captionOpen, CharSequence caption, CharSequence captionClose) {
        this.setCaptionCell(new TableCell(captionOpen, this.options.formatTableCaptionSpaces == DiscretionaryText.AS_IS ? caption : BasedSequenceImpl.of(caption).trim(), captionClose, 1, 1));
    }

    public int getHeadingRowCount() {
        return this.header.rows.size();
    }

    public int getSeparatorRowCount() {
        return this.separator.rows.size();
    }

    public int getBodyRowCount() {
        return this.body.rows.size();
    }

    public int getCaptionRowCount() {
        return this.caption.rows.size();
    }

    public int getMaxHeadingColumns() {
        return this.header.getMaxColumns();
    }

    public int getMaxSeparatorColumns() {
        return this.separator.getMaxColumns();
    }

    public int getMaxBodyColumns() {
        return this.body.getMaxColumns();
    }

    public boolean getHaveCaption() {
        return this.caption.rows.size() > 0 && this.caption.rows.get((int)0).cells.size() > 0 && this.caption.rows.get((int)0).cells.get((int)0).columnSpan != 0;
    }

    public int getMinColumns() {
        int headingColumns = this.header.getMinColumns();
        int separatorColumns = this.separator.getMinColumns();
        int bodyColumns = this.body.getMinColumns();
        return Utils.min(headingColumns == 0 ? Integer.MAX_VALUE : headingColumns, separatorColumns, bodyColumns == 0 ? Integer.MAX_VALUE : bodyColumns);
    }

    public int getMaxColumns() {
        int headingColumns = this.header.getMaxColumns();
        int separatorColumns = this.separator.getMaxColumns();
        int bodyColumns = this.body.getMaxColumns();
        return Utils.max(headingColumns, separatorColumns, bodyColumns);
    }

    public int getMinColumnsWithoutColumns(boolean withSeparator, int ... skipColumns) {
        return this.aggregateTotalColumnsWithoutColumns(withSeparator ? this.ALL_TABLE_ROWS : this.ALL_CONTENT_ROWS, MinAggregator.INSTANCE, skipColumns);
    }

    public int getMaxColumnsWithoutColumns(boolean withSeparator, int ... skipColumns) {
        return this.aggregateTotalColumnsWithoutColumns(withSeparator ? this.ALL_TABLE_ROWS : this.ALL_CONTENT_ROWS, MaxAggregator.INSTANCE, skipColumns);
    }

    public int getMinColumnsWithoutRows(boolean withSeparator, int ... skipRows) {
        return this.aggregateTotalColumnsWithoutRows(withSeparator ? this.ALL_TABLE_ROWS : this.ALL_CONTENT_ROWS, MinAggregator.INSTANCE, skipRows);
    }

    public int getMaxColumnsWithoutRows(boolean withSeparator, int ... skipRows) {
        return this.aggregateTotalColumnsWithoutRows(withSeparator ? this.ALL_TABLE_ROWS : this.ALL_CONTENT_ROWS, MaxAggregator.INSTANCE, skipRows);
    }

    public Map<Integer, Integer> getTrackedOffsets() {
        return this.trackedOffsets;
    }

    public int getTableStartOffset() {
        List<TableRow> rows = this.getAllRows();
        TableRow row = rows.get(0);
        row.normalizeIfNeeded();
        if (row.cells.size() > 0) {
            return row.cells.get(0).getStartOffset(null);
        }
        return 0;
    }

    public TableCellOffsetInfo getCellOffsetInfo(int offset) {
        int r = 0;
        for (TableRow row : this.getAllSectionRows()) {
            row.normalizeIfNeeded();
            TableCell lastCell = row.cells.get(row.cells.size() - 1);
            BasedSequence lastSegment = lastCell.getLastSegment();
            int lineEndOffset = lastSegment.getBaseSequence().indexOfAny("\r\n", lastSegment.getEndOffset());
            if (lineEndOffset == -1) {
                lineEndOffset = lastSegment.getEndOffset();
            }
            if (offset <= lineEndOffset) {
                int i = 0;
                TableCell previousCell = null;
                for (TableCell cell : row.cells) {
                    if (!cell.closeMarker.isEmpty() ? offset < cell.closeMarker.getEndOffset() : offset <= cell.text.getEndOffset()) {
                        if (offset >= cell.getInsideStartOffset(previousCell) && offset <= cell.getInsideEndOffset()) {
                            return new TableCellOffsetInfo(offset, this, this.getAllRowsSection(r), row, cell, r, i, i, offset - cell.getInsideStartOffset(previousCell));
                        }
                        return new TableCellOffsetInfo(offset, this, this.getAllRowsSection(r), row, cell, r, i, null, null);
                    }
                    ++i;
                    previousCell = cell;
                }
                return new TableCellOffsetInfo(offset, this, this.getAllRowsSection(r), row, lastCell, r, i, null, null);
            }
            ++r;
        }
        TableSection lastSection = this.getAllRowsSection(r - 1);
        return new TableCellOffsetInfo(offset, this, lastSection, null, null, r, 0, null, null);
    }

    public boolean addTrackedOffset(int offset) {
        return this.addTrackedOffset(offset, null, false);
    }

    public boolean addTrackedOffset(int offset, boolean afterSpace) {
        return this.addTrackedOffset(offset, Character.valueOf(' '), false);
    }

    public boolean addTrackedOffset(int offset, boolean afterSpace, boolean afterDelete) {
        return this.addTrackedOffset(offset, afterSpace ? Character.valueOf(' ') : null, afterDelete);
    }

    public boolean addTrackedOffset(int offset, Character c, boolean afterDelete) {
        TableCellOffsetInfo info = this.getCellOffsetInfo(offset);
        if (info.getInsideColumn()) {
            info.tableRow.cells.set(info.column, info.tableCell.withTrackedOffset(offset - info.tableCell.getTextStartOffset(info.column == 0 ? null : info.tableRow.cells.get(info.column - 1)), c != null && c.charValue() == ' ', afterDelete));
            return true;
        }
        if (info.isBeforeCells()) {
            info.tableRow.setBeforeOffset(offset);
            return true;
        }
        if (info.isInCellSpan()) {
            info.tableRow.cells.set(info.column, info.tableCell.withSpanTrackedOffset(offset - info.tableCell.getInsideEndOffset()));
            return true;
        }
        if (info.isAfterCells()) {
            info.tableRow.setAfterOffset(offset);
            return true;
        }
        return false;
    }

    public List<TableRow> getAllRows() {
        return this.getAllSectionsRows(this.ALL_TABLE_ROWS);
    }

    public List<TableRow> getAllContentRows() {
        return this.getAllSectionsRows(this.ALL_CONTENT_ROWS);
    }

    public List<TableRow> getAllSectionRows() {
        return this.getAllSectionsRows(this.ALL_SECTIONS);
    }

    private List<TableRow> getAllSectionsRows(TableSection ... sections) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(this.header.rows.size() + this.body.rows.size());
        for (TableSection section : sections) {
            rows.addAll(section.rows);
        }
        return rows;
    }

    public boolean isAllRowsSeparator(int index) {
        return index >= this.header.rows.size() && index < this.header.rows.size() + this.separator.rows.size();
    }

    public TableSection getAllRowsSection(int index) {
        for (TableSection section : this.ALL_SECTIONS) {
            if (index < section.rows.size()) {
                return section;
            }
            index -= section.rows.size();
        }
        return null;
    }

    public int getAllRowsCount() {
        return this.header.rows.size() + this.separator.rows.size() + this.body.rows.size();
    }

    public int getAllContentRowsCount() {
        return this.header.rows.size() + this.body.rows.size();
    }

    public int getAllSectionsRowsCount() {
        return this.header.rows.size() + this.separator.rows.size() + this.body.rows.size() + this.caption.rows.size();
    }

    public void forAllRows(TableRowManipulator manipulator) {
        this.forAllSectionsRows(0, Integer.MAX_VALUE, this.ALL_TABLE_ROWS, manipulator);
    }

    public void forAllRows(int startIndex, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, Integer.MAX_VALUE, this.ALL_TABLE_ROWS, manipulator);
    }

    public void forAllRows(int startIndex, int count, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, count, this.ALL_TABLE_ROWS, manipulator);
    }

    public void forAllContentRows(TableRowManipulator manipulator) {
        this.forAllSectionsRows(0, Integer.MAX_VALUE, this.ALL_CONTENT_ROWS, manipulator);
    }

    public void forAllContentRows(int startIndex, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, Integer.MAX_VALUE, this.ALL_CONTENT_ROWS, manipulator);
    }

    public void forAllContentRows(int startIndex, int count, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, count, this.ALL_CONTENT_ROWS, manipulator);
    }

    public void forAllSectionRows(TableRowManipulator manipulator) {
        this.forAllSectionsRows(0, Integer.MAX_VALUE, this.ALL_SECTIONS, manipulator);
    }

    public void forAllSectionRows(int startIndex, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, Integer.MAX_VALUE, this.ALL_SECTIONS, manipulator);
    }

    public void forAllSectionRows(int startIndex, int count, TableRowManipulator manipulator) {
        this.forAllSectionsRows(startIndex, count, this.ALL_SECTIONS, manipulator);
    }

    public void deleteRows(int rowIndex, int count) {
        block3: {
            block2: {
                int maxColumns = this.getMaxColumns();
                boolean[] handled = new boolean[]{false};
                if (rowIndex > this.header.rows.size()) break block2;
                int i = count;
                while (i-- > 0 && rowIndex < this.header.rows.size()) {
                    this.header.rows.remove(rowIndex);
                }
                break block3;
            }
            if (rowIndex < this.header.rows.size() + this.separator.rows.size()) break block3;
            int index = rowIndex - this.header.rows.size() - this.separator.rows.size();
            int i = count;
            while (i-- > 0 && index < this.body.rows.size()) {
                this.body.rows.remove(index);
            }
        }
    }

    public void insertRows(int rowIndex, int count) {
        int maxColumns = this.getMaxColumns();
        boolean[] handled = new boolean[]{false};
        if (rowIndex <= this.header.rows.size()) {
            this.insertRows(this.header.rows, rowIndex, count, maxColumns);
        } else {
            this.insertRows(this.body.rows, Utils.rangeLimit(rowIndex - this.header.rows.size() - this.separator.rows.size(), 0, this.body.rows.size()), count, maxColumns);
        }
    }

    private void insertRows(ArrayList<TableRow> rows, int index, int count, int maxColumns) {
        int i = count;
        while (i-- > 0) {
            TableRow emptyRow = new TableRow();
            emptyRow.appendColumns(maxColumns);
            if (index >= rows.size()) {
                rows.add(emptyRow);
                continue;
            }
            rows.add(index, emptyRow);
        }
    }

    public void insertColumns(final int column, final int count) {
        this.forAllContentRows(new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                rows.get(index).insertColumns(column, count);
                return 0;
            }
        });
        for (TableRow row : this.separator.rows) {
            row.insertColumns(column, count);
        }
    }

    public void deleteColumns(final int column, final int count) {
        this.forAllContentRows(new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                rows.get(index).deleteColumns(column, count);
                return 0;
            }
        });
        for (TableRow row : this.separator.rows) {
            row.deleteColumns(column, count);
        }
    }

    public void moveColumn(final int fromColumn, final int toColumn) {
        this.forAllContentRows(new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                rows.get(index).moveColumn(fromColumn, toColumn);
                return 0;
            }
        });
        for (TableRow row : this.separator.rows) {
            row.moveColumn(fromColumn, toColumn);
        }
    }

    public boolean isEmptyColumn(final int column) {
        final boolean[] result = new boolean[]{true};
        this.forAllContentRows(new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                if (!row.isEmptyColumn(column)) {
                    result[0] = false;
                    return Integer.MIN_VALUE;
                }
                return 0;
            }
        });
        return result[0];
    }

    public boolean isAllRowsEmptyAt(int rowIndex) {
        return this.isEmptyRowAt(rowIndex, this.ALL_TABLE_ROWS);
    }

    public boolean isContentRowsEmptyAt(int rowIndex) {
        return this.isEmptyRowAt(rowIndex, this.ALL_CONTENT_ROWS);
    }

    private boolean isEmptyRowAt(int rowIndex, TableSection[] sections) {
        final boolean[] result = new boolean[]{false};
        this.forAllSectionsRows(rowIndex, 1, sections, new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                if (row.isEmpty()) {
                    result[0] = true;
                }
                return Integer.MIN_VALUE;
            }
        });
        return result[0];
    }

    public boolean getHeader() {
        return this.isHeading;
    }

    public void setHeader(boolean header) {
        this.isHeading = header;
    }

    public boolean isSeparator() {
        return this.isSeparator;
    }

    public void setSeparator(boolean separator) {
        this.isSeparator = separator;
    }

    public void nextRow() {
        if (this.isSeparator) {
            throw new IllegalStateException("Only one separator row allowed");
        }
        if (this.isHeading) {
            this.header.nextRow();
        } else {
            this.body.nextRow();
        }
    }

    public void addCell(TableCell cell) {
        TableSection tableSection;
        TableSection tableSection2 = this.isSeparator ? this.separator : (tableSection = this.isHeading ? this.header : this.body);
        if (this.isSeparator && (cell.columnSpan != 1 || cell.rowSpan != 1)) {
            throw new IllegalStateException("Separator columns cannot span rows/columns");
        }
        TableRow currentRow = tableSection.get(tableSection.row);
        while (tableSection.column < currentRow.cells.size() && currentRow.cells.get(tableSection.column) != null) {
            ++tableSection.column;
        }
        block1: for (int rowSpan = 0; rowSpan < cell.rowSpan; ++rowSpan) {
            tableSection.get(tableSection.row + rowSpan).set(tableSection.column, cell);
            for (int columnSpan = 1; columnSpan < cell.columnSpan; ++columnSpan) {
                tableSection.expandTo(tableSection.row + rowSpan, tableSection.column + columnSpan);
                if (tableSection.get((int)(tableSection.row + rowSpan)).cells.get(tableSection.column + columnSpan) != null) continue block1;
                tableSection.rows.get(tableSection.row + rowSpan).set(tableSection.column + columnSpan, TableCell.NULL);
            }
        }
        tableSection.column += cell.columnSpan;
    }

    public void normalize() {
        this.header.normalize();
        this.separator.normalize();
        this.body.normalize();
    }

    public void finalizeTable() {
        int j;
        int width;
        BasedSequence cellText;
        TableCell cell;
        int k;
        int kMax;
        String colonTrimChars = ":";
        this.normalize();
        if (this.options.fillMissingColumns) {
            this.fillMissingColumns();
        }
        int sepColumns = this.getMaxColumns();
        this.alignments = new CellAlignment[sepColumns];
        this.columnWidths = new int[sepColumns];
        BitSet spanAlignment = new BitSet(sepColumns);
        ArrayList<ColumnSpan> columnSpans = new ArrayList<ColumnSpan>();
        Ref<Integer> delta = new Ref<Integer>(0);
        if (this.separator.rows.size() > 0) {
            TableRow row = this.separator.rows.get(0);
            int j2 = 0;
            int jSpan = 0;
            delta.value = 0;
            for (TableCell cell2 : row.cells) {
                if ((this.alignments[jSpan] == null || cell2.columnSpan == 1 && spanAlignment.get(jSpan)) && cell2.alignment != CellAlignment.NONE) {
                    this.alignments[jSpan] = cell2.alignment;
                    if (cell2.columnSpan > 1) {
                        spanAlignment.set(jSpan);
                    }
                }
                ++j2;
                jSpan += cell2.columnSpan;
            }
        }
        if (this.header.rows.size() > 0) {
            int i = 0;
            for (TableRow row : this.header.rows) {
                int j3 = 0;
                int jSpan = 0;
                delta.value = 0;
                kMax = row.cells.size();
                for (k = 0; k < kMax; ++k) {
                    cell = row.cells.get(k);
                    if ((this.alignments[jSpan] == null || cell.columnSpan == 1 && spanAlignment.get(jSpan)) && cell.alignment != CellAlignment.NONE) {
                        this.alignments[jSpan] = cell.alignment;
                        if (cell.columnSpan > 1) {
                            spanAlignment.set(jSpan);
                        }
                    }
                    cellText = this.cellText(row.cells, k, false, true, 0, null, delta);
                    width = this.options.charWidthProvider.charWidth(cellText) + this.options.spacePad + this.options.pipeWidth * cell.columnSpan;
                    if (cell.columnSpan > 1) {
                        columnSpans.add(new ColumnSpan(j3, cell.columnSpan, width));
                    } else if (this.columnWidths[jSpan] < width) {
                        this.columnWidths[jSpan] = width;
                    }
                    ++j3;
                    jSpan += cell.columnSpan;
                }
                ++i;
            }
        }
        if (this.body.rows.size() > 0) {
            int i = 0;
            delta.value = 0;
            for (TableRow row : this.body.rows) {
                int j4 = 0;
                int jSpan = 0;
                kMax = row.cells.size();
                for (k = 0; k < kMax; ++k) {
                    cell = row.cells.get(k);
                    cellText = this.cellText(row.cells, k, false, false, 0, null, delta);
                    width = this.options.charWidthProvider.charWidth(cellText) + this.options.spacePad + this.options.pipeWidth * cell.columnSpan;
                    if (cell.columnSpan > 1) {
                        columnSpans.add(new ColumnSpan(jSpan, cell.columnSpan, width));
                    } else if (this.columnWidths[jSpan] < width) {
                        this.columnWidths[jSpan] = width;
                    }
                    ++j4;
                    jSpan += cell.columnSpan;
                }
                ++i;
            }
        }
        if (this.separator.rows.size() == 0 || this.body.rows.size() > 0 || this.header.rows.size() > 0) {
            j = 0;
            delta.value = 0;
            CellAlignment[] j2 = this.alignments;
            int row = j2.length;
            for (int j4 = 0; j4 < row; ++j4) {
                int dashCount = 0;
                CellAlignment alignment = j2[j4];
                CellAlignment alignment1 = this.adjustCellAlignment(alignment);
                int colonCount = alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.RIGHT ? 1 : (alignment1 == CellAlignment.CENTER ? 2 : 0);
                int dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes);
                if (dashCount < dashesOnly) {
                    dashCount = dashesOnly;
                }
                if (this.columnWidths[j] < (width = dashCount * this.options.dashWidth + colonCount * this.options.colonWidth + this.options.pipeWidth)) {
                    this.columnWidths[j] = width;
                }
                ++j;
            }
        } else {
            j = 0;
            delta.value = 0;
            for (TableCell cell3 : this.separator.rows.get((int)0).cells) {
                int width2;
                int dashesOnly;
                CellAlignment alignment = this.adjustCellAlignment(cell3.alignment);
                int colonCount = alignment == CellAlignment.LEFT || alignment == CellAlignment.RIGHT ? 1 : (alignment == CellAlignment.CENTER ? 2 : 0);
                BasedSequence trim = cell3.text.trim(colonTrimChars);
                int dashCount = trim.length();
                if (dashCount < (dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes))) {
                    dashCount = dashesOnly;
                }
                if (this.columnWidths[j] < (width2 = dashCount * this.options.dashWidth + colonCount * this.options.colonWidth + this.options.pipeWidth)) {
                    this.columnWidths[j] = width2;
                }
                ++j;
            }
        }
        if (!columnSpans.isEmpty()) {
            int[] additionalWidths = new int[sepColumns];
            BitSet unfixedColumns = new BitSet(sepColumns);
            ArrayList<ColumnSpan> newColumnSpans = new ArrayList<ColumnSpan>(columnSpans.size());
            for (ColumnSpan columnSpan : columnSpans) {
                int spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                if (spanWidth >= columnSpan.width) continue;
                unfixedColumns.set(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan);
                newColumnSpans.add(columnSpan);
            }
            while (!newColumnSpans.isEmpty()) {
                int fixedWidth;
                int spanWidth;
                columnSpans = newColumnSpans;
                BitSet fixedColumns = new BitSet(sepColumns);
                newColumnSpans.clear();
                for (ColumnSpan columnSpan : columnSpans) {
                    spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                    if (spanWidth <= (fixedWidth = this.spanFixedWidth(unfixedColumns, columnSpan.startColumn, columnSpan.columnSpan))) {
                        fixedColumns.set(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan);
                        continue;
                    }
                    newColumnSpans.add(columnSpan);
                }
                unfixedColumns.andNot(fixedColumns);
                columnSpans = newColumnSpans;
                newColumnSpans.clear();
                for (ColumnSpan columnSpan : columnSpans) {
                    spanWidth = this.spanWidth(columnSpan.startColumn, columnSpan.columnSpan);
                    if (spanWidth <= (fixedWidth = this.spanFixedWidth(unfixedColumns, columnSpan.startColumn, columnSpan.columnSpan))) continue;
                    int distributeWidth = spanWidth - fixedWidth;
                    int unfixedColumnCount = unfixedColumns.get(columnSpan.startColumn, columnSpan.startColumn + columnSpan.columnSpan).cardinality();
                    int perSpanWidth = distributeWidth / unfixedColumnCount;
                    int extraWidth = distributeWidth - perSpanWidth * unfixedColumnCount;
                    for (int i = 0; i < columnSpan.columnSpan; ++i) {
                        if (!unfixedColumns.get(columnSpan.startColumn + i)) continue;
                        int n = columnSpan.startColumn + i;
                        this.columnWidths[n] = this.columnWidths[n] + perSpanWidth;
                        if (extraWidth <= 0) continue;
                        int n2 = columnSpan.startColumn + i;
                        this.columnWidths[n2] = this.columnWidths[n2] + 1;
                        --extraWidth;
                    }
                    newColumnSpans.add(columnSpan);
                }
            }
        }
    }

    public void fillMissingColumns() {
        this.fillMissingColumns(null);
    }

    public void fillMissingColumns(Integer minColumn) {
        int maxColumns;
        int minColumns = this.getMinColumns();
        if (minColumns < (maxColumns = this.getMaxColumns())) {
            TableCell empty = TableCell.DEFAULT_CELL;
            for (TableRow row : this.header.rows) {
                row.fillMissingColumns(minColumn, maxColumns, empty);
            }
            for (TableRow row : this.body.rows) {
                row.fillMissingColumns(minColumn, maxColumns, empty);
            }
        }
    }

    public void appendTable(FormattingAppendable out) {
        TableRow row;
        Ref<Integer> delta = new Ref<Integer>(0);
        String linePrefix = this.options.formatTableIndentPrefix;
        this.trackedOffsets.clear();
        int formatterOptions = out.getOptions();
        out.setOptions(formatterOptions & 0xFFFFFFFD);
        this.finalizeTable();
        this.appendRows(out, this.header.rows, true, linePrefix, delta);
        out.append(linePrefix);
        TableRow tableRow = row = this.separator.rows.size() > 0 ? this.separator.rows.get(0) : null;
        if (row != null && row.beforeOffset != Integer.MAX_VALUE) {
            this.trackedOffsets.put(row.beforeOffset, out.offsetWithPending());
        }
        int j = 0;
        delta.value = 0;
        for (CellAlignment alignment : this.alignments) {
            List<TableCell> cells;
            int dashesOnly;
            CellAlignment alignment1 = this.adjustCellAlignment(alignment);
            int colonCount = alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.RIGHT ? 1 : (alignment1 == CellAlignment.CENTER ? 2 : 0);
            int dashCount = (this.columnWidths[j] - colonCount * this.options.colonWidth - this.options.pipeWidth) / this.options.dashWidth;
            if (dashCount < (dashesOnly = Utils.minLimit(dashCount, this.options.minSeparatorColumnWidth - colonCount, this.options.minSeparatorDashes))) {
                dashCount = dashesOnly;
            }
            if ((Integer)delta.value * 2 >= this.options.dashWidth) {
                ++dashCount;
                Ref<Integer> ref = delta;
                Integer.valueOf((Integer)ref.value - this.options.dashWidth);
                ref.value = ref.value;
            }
            boolean handled = false;
            int trackedPos = Integer.MAX_VALUE;
            TableCell cell = null;
            TableCell previousCell = null;
            if (row != null && j < (cells = row.cells).size()) {
                cell = cells.get(j);
                if (j > 0) {
                    previousCell = cells.get(j - 1);
                }
            }
            int n = trackedPos = cell == null ? Integer.MAX_VALUE : Utils.minLimit(cell.trackedTextOffset, 0);
            if (trackedPos != Integer.MAX_VALUE) {
                boolean afterLastDash;
                if (this.options.leadTrailPipes && j == 0) {
                    out.append('|');
                }
                boolean beforeFirstColon = trackedPos == 0 && cell.text.charAt(trackedPos) == ':';
                boolean afterFirstColon = trackedPos == 1 && cell.text.charAt(trackedPos - 1) == ':';
                boolean beforeLastColon = trackedPos == cell.text.length() - 1 && cell.text.charAt(trackedPos) == ':';
                boolean afterLastColon = trackedPos == cell.text.length() && cell.text.charAt(trackedPos - 1) == ':';
                boolean bl = afterLastDash = trackedPos == cell.text.length() && cell.text.charAt(trackedPos - 1) == '-';
                if (alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.CENTER) {
                    if (beforeFirstColon) {
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                        out.append(':');
                    } else if (afterFirstColon) {
                        out.append(':');
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                    } else {
                        out.append(':');
                    }
                } else {
                    beforeFirstColon = false;
                    afterFirstColon = false;
                }
                if (!(afterFirstColon || beforeFirstColon || afterLastColon || beforeLastColon)) {
                    if (trackedPos == 0) {
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                        out.repeat('-', dashCount);
                    } else if (!afterLastDash && trackedPos < dashCount) {
                        out.repeat('-', trackedPos);
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        out.repeat('-', dashCount - trackedPos);
                        trackedPos = Integer.MAX_VALUE;
                    } else {
                        out.repeat('-', dashCount);
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                    }
                } else {
                    out.repeat('-', dashCount);
                }
                if (alignment1 == CellAlignment.RIGHT || alignment1 == CellAlignment.CENTER) {
                    if (afterLastColon) {
                        out.append(':');
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                    } else if (beforeLastColon) {
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                        trackedPos = Integer.MAX_VALUE;
                        out.append(':');
                    } else {
                        out.append(':');
                    }
                } else if (afterLastColon || beforeLastColon) {
                    this.trackedOffsets.put(cell.trackedTextOffset + cell.getInsideStartOffset(previousCell), out.offsetWithPending());
                    trackedPos = Integer.MAX_VALUE;
                }
                assert (trackedPos == Integer.MAX_VALUE);
            } else {
                if (this.options.leadTrailPipes && j == 0) {
                    out.append('|');
                }
                if (alignment1 == CellAlignment.LEFT || alignment1 == CellAlignment.CENTER) {
                    out.append(':');
                }
                out.repeat('-', dashCount);
                if (alignment1 == CellAlignment.RIGHT || alignment1 == CellAlignment.CENTER) {
                    out.append(':');
                }
            }
            if (!this.options.leadTrailPipes && ++j >= this.alignments.length) continue;
            out.append('|');
        }
        if (row != null && row.afterOffset != Integer.MAX_VALUE) {
            this.trackedOffsets.put(row.afterOffset, out.offsetWithPending());
        }
        out.line();
        this.appendRows(out, this.body.rows, false, linePrefix, delta);
        TableCell captionCell = this.getCaptionCell();
        String captionText = MarkdownTable.formattedCaption(captionCell.text, this.options);
        if (captionText != null) {
            BasedSequence formattedCaption = BasedSequenceImpl.of(captionText);
            boolean handled = false;
            if (this.caption.rows.size() > 0) {
                TableRow row2 = this.caption.rows.get(0);
                if (captionCell.trackedTextOffset != Integer.MAX_VALUE || row2.beforeOffset != Integer.MAX_VALUE || row2.afterOffset != Integer.MAX_VALUE) {
                    TableCell cell = captionCell;
                    out.line();
                    if (row2 != null && row2.beforeOffset != Integer.MAX_VALUE) {
                        this.trackedOffsets.put(row2.beforeOffset, out.offsetWithPending());
                    }
                    captionCell = captionCell.withText(captionCell.text.trim());
                    if (cell.trackedTextOffset != Integer.MAX_VALUE) {
                        captionCell = captionCell.withTrackedOffset(Utils.minLimit(cell.trackedTextOffset - cell.text.trimmedStart().length(), 0));
                    }
                    boolean addOpenCaptionSpace = false;
                    boolean addCloseCaptionSpace = false;
                    if (!captionCell.text.isBlank()) {
                        switch (this.options.formatTableCaptionSpaces) {
                            case ADD: {
                                addOpenCaptionSpace = true;
                                addCloseCaptionSpace = true;
                                break;
                            }
                            case REMOVE: {
                                break;
                            }
                            default: {
                                addOpenCaptionSpace = cell.text.startsWith(" ");
                                addCloseCaptionSpace = cell.text.endsWith(" ");
                            }
                        }
                    }
                    out.append('[');
                    if (addOpenCaptionSpace) {
                        out.append(' ');
                    }
                    int cellOffset = out.offsetWithPending();
                    row2.cells.set(0, captionCell);
                    delta.value = 0;
                    BasedSequence cellText = this.cellText(row2.cells, 0, true, false, 0, CellAlignment.LEFT, delta);
                    int captionOffset = out.offsetWithPending();
                    if (cell.trackedTextOffset != Integer.MAX_VALUE) {
                        TableCell adjustedCell = row2.cells.get(0);
                        if (adjustedCell.trackedTextOffset != Integer.MAX_VALUE) {
                            this.trackedOffsets.put(cell.trackedTextOffset + cell.text.getStartOffset(), cellOffset + (cellText.isBlank() ? 1 : Utils.minLimit(adjustedCell.trackedTextOffset, 0) + adjustedCell.trackedTextAdjust));
                        }
                    }
                    row2.cells.set(0, cell);
                    out.append(cellText);
                    if (addCloseCaptionSpace) {
                        out.append(' ');
                    }
                    out.append(']');
                    if (row2 != null && row2.afterOffset != Integer.MAX_VALUE) {
                        this.trackedOffsets.put(row2.afterOffset, out.offsetWithPending());
                    }
                    out.line();
                    handled = true;
                }
            }
            if (!handled) {
                out.setOptions(formatterOptions);
                out.line().append('[').append(formattedCaption).append(']').line();
            }
        }
        out.setOptions(formatterOptions);
    }

    public static void appendFormattedCaption(FormattingAppendable out, BasedSequence caption, TableFormatOptions options) {
        String formattedCaption = MarkdownTable.formattedCaption(caption, options);
        if (formattedCaption != null) {
            out.line().append('[').append(formattedCaption).append(']').line();
        }
    }

    public static String formattedCaption(BasedSequence caption, TableFormatOptions options) {
        boolean append = caption.isNotNull();
        switch (options.formatTableCaption) {
            case ADD: {
                append = true;
                break;
            }
            case REMOVE_EMPTY: {
                append = !caption.isBlank();
                break;
            }
            case REMOVE: {
                append = false;
                break;
            }
            default: {
                if (!options.removeCaption) break;
                append = false;
            }
        }
        if (append) {
            String captionSpaces = "";
            BasedSequence useCaption = caption;
            switch (options.formatTableCaptionSpaces) {
                case ADD: {
                    captionSpaces = " ";
                    useCaption = caption.trim();
                    break;
                }
                case REMOVE: {
                    useCaption = caption.trim();
                    break;
                }
            }
            return captionSpaces + caption.toString() + captionSpaces;
        }
        return null;
    }

    private boolean pipeNeedsSpaceBefore(TableCell cell) {
        return cell.text.equals(" ") || !cell.text.endsWith(" ");
    }

    private boolean pipeNeedsSpaceAfter(TableCell cell) {
        return cell.text.equals(" ") || !cell.text.startsWith(" ");
    }

    private void appendRows(FormattingAppendable out, List<TableRow> rows, boolean isHeader, String linePrefix, Ref<Integer> delta) {
        for (TableRow row : rows) {
            int j = 0;
            int jSpan = 0;
            delta.value = 0;
            out.append(linePrefix);
            if (row.beforeOffset != Integer.MAX_VALUE) {
                this.trackedOffsets.put(row.beforeOffset, out.offsetWithPending());
            }
            int iMax = row.cells.size();
            for (int i = 0; i < iMax; ++i) {
                TableCell cell = row.cells.get(i);
                if (j == 0) {
                    if (this.options.leadTrailPipes) {
                        out.append('|');
                        if (this.options.spaceAroundPipes && this.pipeNeedsSpaceAfter(cell)) {
                            out.append(' ');
                        }
                    }
                } else if (this.options.spaceAroundPipes && this.pipeNeedsSpaceAfter(cell)) {
                    out.append(' ');
                }
                CellAlignment cellAlignment = isHeader && cell.alignment != CellAlignment.NONE ? cell.alignment : this.alignments[jSpan];
                BasedSequence cellText = this.cellText(row.cells, i, true, isHeader, this.spanWidth(jSpan, cell.columnSpan) - this.options.spacePad - this.options.pipeWidth * cell.columnSpan, cellAlignment, delta);
                if (cell.trackedTextOffset != Integer.MAX_VALUE) {
                    TableCell adjustedCell = row.cells.get(i);
                    if (adjustedCell.trackedTextOffset != Integer.MAX_VALUE) {
                        int cellOffset = out.offsetWithPending();
                        int adjustForBlank = cell.text.isBlank() ? -1 : 0;
                        this.trackedOffsets.put(cell.trackedTextOffset + cell.getTextStartOffset(i == 0 ? null : row.cells.get(i - 1)), cellOffset + Utils.minLimit(adjustedCell.trackedTextOffset + adjustForBlank, 0) + adjustedCell.trackedTextAdjust);
                    }
                }
                out.append(cellText);
                jSpan += cell.columnSpan;
                if (++j < this.alignments.length) {
                    if (this.options.spaceAroundPipes && this.pipeNeedsSpaceBefore(cell)) {
                        out.append(' ');
                    }
                    this.appendColumnSpan(out, cell.columnSpan, cell.getInsideEndOffset(), cell.spanTrackedOffset, this.trackedOffsets);
                    continue;
                }
                if (this.options.leadTrailPipes) {
                    if (this.options.spaceAroundPipes && this.pipeNeedsSpaceBefore(cell)) {
                        out.append(' ');
                    }
                    this.appendColumnSpan(out, cell.columnSpan, cell.getInsideEndOffset(), cell.spanTrackedOffset, this.trackedOffsets);
                    continue;
                }
                if (this.options.spaceAroundPipes && this.pipeNeedsSpaceBefore(cell)) {
                    out.append(' ');
                }
                this.appendColumnSpan(out, cell.columnSpan - 1, cell.getInsideEndOffset(), cell.spanTrackedOffset, this.trackedOffsets);
            }
            if (row.afterOffset != Integer.MAX_VALUE) {
                this.trackedOffsets.put(row.afterOffset, out.offsetWithPending());
            }
            if (j <= 0) continue;
            out.line();
        }
    }

    private void appendColumnSpan(FormattingAppendable out, int span, int cellInsideEndOffset, int trackedSpanOffset, HashMap<Integer, Integer> offsets) {
        if (trackedSpanOffset == Integer.MAX_VALUE) {
            out.repeat('|', span);
        } else if (trackedSpanOffset == 0) {
            if (offsets != null) {
                offsets.put(cellInsideEndOffset + trackedSpanOffset, out.offsetWithPending());
            }
            out.repeat('|', span);
        } else if (trackedSpanOffset < span) {
            out.repeat('|', trackedSpanOffset);
            if (offsets != null) {
                offsets.put(cellInsideEndOffset + trackedSpanOffset, out.offsetWithPending());
            }
            out.repeat('|', span - trackedSpanOffset);
        } else {
            out.repeat('|', span);
            if (offsets != null) {
                offsets.put(cellInsideEndOffset + trackedSpanOffset, out.offsetWithPending());
            }
        }
    }

    private BasedSequence cellText(List<TableCell> cells, int index, boolean withTrackedOffset, boolean isHeader, int width, CellAlignment alignment, Ref<Integer> accumulatedDelta) {
        TableCell cell;
        TableCell adjustedCell = cell = cells.get(index);
        BasedSequence text = cell.text;
        boolean needsPadding = cell.trackedTextOffset != Integer.MAX_VALUE && cell.trackedTextOffset >= cell.text.length();
        int suffixed = 0;
        boolean neededPrefix = false;
        if (cell.trackedTextOffset != Integer.MAX_VALUE) {
            if (cell.trackedTextOffset > cell.text.length()) {
                suffixed = cell.trackedTextOffset - cell.text.length() - 1;
                text = text.append(RepeatedCharSequence.of(' ', suffixed));
            } else if (cell.trackedTextOffset < 0) {
                boolean tmp = false;
                neededPrefix = true;
            }
        }
        int length = this.options.charWidthProvider.charWidth(text);
        if (this.options.adjustColumnWidth && (length < width || cell.trackedTextOffset > cell.text.length())) {
            if (!this.options.applyColumnAlignment || alignment == null || alignment == CellAlignment.NONE) {
                alignment = isHeader && this.options.leftAlignMarker != DiscretionaryText.ADD ? CellAlignment.CENTER : CellAlignment.LEFT;
            } else if (isHeader && alignment == CellAlignment.LEFT && this.options.leftAlignMarker == DiscretionaryText.REMOVE) {
                alignment = CellAlignment.CENTER;
            }
            int diff = width - length;
            int spaceCount = diff / this.options.spaceWidth;
            if ((Integer)accumulatedDelta.value * 2 >= this.options.spaceWidth) {
                ++spaceCount;
                Ref<Integer> ref = accumulatedDelta;
                ref.value = (Integer)ref.value - this.options.spaceWidth;
            }
            switch (alignment) {
                case LEFT: {
                    if (spaceCount > 0) {
                        text = text.append(PrefixedSubSequence.repeatOf(" ", spaceCount, text.subSequence(0, 0)));
                    }
                    if (!withTrackedOffset || !needsPadding || !cell.afterSpace || spaceCount > 0) break;
                    adjustedCell = adjustedCell.withTrackedTextAdjust(1);
                    break;
                }
                case RIGHT: {
                    if (spaceCount > 0) {
                        text = PrefixedSubSequence.repeatOf(" ", spaceCount, text);
                        if (withTrackedOffset && cell.trackedTextOffset != Integer.MAX_VALUE) {
                            adjustedCell = cell.withTrackedOffset(Utils.maxLimit(text.length(), cell.trackedTextOffset + spaceCount));
                        }
                        if (withTrackedOffset && neededPrefix && cell.afterSpace) {
                            adjustedCell = adjustedCell.withTrackedTextAdjust(1);
                        }
                    }
                    if (!withTrackedOffset || !needsPadding || !cell.afterSpace || spaceCount > 0 && cell.afterDelete) break;
                    adjustedCell = adjustedCell.withTrackedTextAdjust(1);
                    break;
                }
                case CENTER: {
                    int count = spaceCount / 2;
                    if (spaceCount > 0) {
                        text = PrefixedSubSequence.repeatOf(" ", count, text).append(PrefixedSubSequence.repeatOf(" ", spaceCount - count, text.subSequence(0, 0)));
                        if (withTrackedOffset && cell.trackedTextOffset != Integer.MAX_VALUE) {
                            adjustedCell = cell.withTrackedOffset(Utils.maxLimit(text.length(), cell.trackedTextOffset + count));
                        }
                        if (!withTrackedOffset || !neededPrefix || !cell.afterSpace) break;
                        adjustedCell = adjustedCell.withTrackedTextAdjust(1);
                        break;
                    }
                    if (!withTrackedOffset || !needsPadding || !cell.afterSpace) break;
                    adjustedCell = adjustedCell.withTrackedTextAdjust(1);
                }
            }
        }
        if (withTrackedOffset && adjustedCell.trackedTextOffset != Integer.MAX_VALUE) {
            if (adjustedCell.trackedTextOffset > text.length()) {
                adjustedCell = adjustedCell.withTrackedOffset(text.length());
            }
            if (adjustedCell != cell) {
                cells.set(index, adjustedCell);
            }
        }
        return text;
    }

    private int spanWidth(int col, int columnSpan) {
        if (columnSpan > 1) {
            int width = 0;
            for (int i = 0; i < columnSpan; ++i) {
                width += this.columnWidths[i + col];
            }
            return width;
        }
        return this.columnWidths[col];
    }

    private int spanFixedWidth(BitSet unfixedColumns, int col, int columnSpan) {
        if (columnSpan > 1) {
            int width = 0;
            for (int i = 0; i < columnSpan; ++i) {
                if (unfixedColumns.get(i)) continue;
                width += this.columnWidths[i + col];
            }
            return width;
        }
        return this.columnWidths[col];
    }

    private CellAlignment adjustCellAlignment(CellAlignment alignment) {
        switch (this.options.leftAlignMarker) {
            case ADD: {
                if (alignment != null && alignment != CellAlignment.NONE) break;
                alignment = CellAlignment.LEFT;
                break;
            }
            case REMOVE: {
                if (alignment != CellAlignment.LEFT) break;
                alignment = CellAlignment.NONE;
                break;
            }
        }
        return alignment;
    }

    private int aggregateTotalColumnsWithoutColumns(TableSection[] sections, final BiFunction<Integer, Integer, Integer> aggregator, final int ... skipColumns) {
        final Integer[] columns = new Integer[]{null};
        this.forAllSectionsRows(0, Integer.MAX_VALUE, sections, new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                int iMax = row.cells.size();
                int count = 0;
                for (int i = 0; i < iMax; ++i) {
                    if (Utils.contained(i, skipColumns)) continue;
                    count += row.cells.get((int)i).columnSpan;
                }
                if (count != 0) {
                    columns[0] = (Integer)aggregator.apply(columns[0], count);
                }
                return 0;
            }
        });
        return columns[0] == null ? 0 : columns[0];
    }

    private int aggregateTotalColumnsWithoutRows(TableSection[] sections, final BiFunction<Integer, Integer, Integer> aggregator, final int ... skipRows) {
        final Integer[] columns = new Integer[]{null};
        this.forAllSectionsRows(0, Integer.MAX_VALUE, sections, new TableRowManipulator(){

            @Override
            public int apply(TableRow row, int allRowsIndex, ArrayList<TableRow> rows, int index) {
                int totalColumns;
                if (!Utils.contained(allRowsIndex, skipRows) && (totalColumns = row.getTotalColumns()) > 0) {
                    columns[0] = (Integer)aggregator.apply(columns[0], totalColumns);
                }
                return 0;
            }
        });
        return columns[0] == null ? 0 : columns[0];
    }

    private void forAllSectionsRows(int startIndex, int count, TableSection[] sections, TableRowManipulator manipulator) {
        if (count <= 0) {
            return;
        }
        int remaining = count;
        int sectionIndex = startIndex;
        int allRowsIndex = startIndex;
        for (TableSection section : sections) {
            if (sectionIndex >= section.rows.size()) {
                sectionIndex -= section.rows.size();
                continue;
            }
            int currentIndex = sectionIndex;
            sectionIndex = 0;
            while (currentIndex < section.rows.size()) {
                int result = manipulator.apply(section.rows.get(currentIndex), allRowsIndex, section.rows, currentIndex);
                if (result == Integer.MIN_VALUE) {
                    return;
                }
                if (result < 0) {
                    allRowsIndex -= result;
                    remaining += result;
                } else {
                    currentIndex += result + 1;
                    --remaining;
                }
                if (remaining <= 0) {
                    return;
                }
                ++allRowsIndex;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{header=" + this.header + ",\nseparator=" + this.separator + ",\nbody=" + this.body + ",\ncaption=" + this.caption + ",\noptions=" + this.options + ",\ntrackedOffsets=" + this.trackedOffsets + "}";
    }

    public static class IndexSpanOffset {
        public final int index;
        public final int spanOffset;

        public IndexSpanOffset(int index, int spanOffset) {
            this.index = index;
            this.spanOffset = spanOffset;
        }

        public String toString() {
            return "IndexSpanOffset{index=" + this.index + ", spanOffset=" + this.spanOffset + '}';
        }
    }

    private static class ColumnSpan {
        final int startColumn;
        final int columnSpan;
        final int width;
        int additionalWidth;

        public ColumnSpan(int startColumn, int columnSpan, int width) {
            this.startColumn = startColumn;
            this.columnSpan = columnSpan;
            this.width = width;
            this.additionalWidth = 0;
        }
    }
}

