/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;

public final class CharSubSequence
extends BasedSequenceImpl {
    private final char[] baseChars;
    private final CharSubSequence base;
    private final int startOffset;
    private final int endOffset;

    @Override
    public CharSubSequence getBaseSequence() {
        return this.base;
    }

    public char[] getBase() {
        return this.baseChars;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    private CharSubSequence(char[] chars) {
        int iMax = chars.length;
        for (int i = 0; i < iMax; ++i) {
            if (chars[i] != '\u0000') continue;
            chars[i] = 65533;
        }
        this.baseChars = chars;
        this.startOffset = 0;
        this.endOffset = this.baseChars.length;
        this.base = this;
    }

    private CharSubSequence(CharSubSequence baseSeq, int start, int end) {
        assert (start > 0 || end < baseSeq.length());
        this.base = baseSeq;
        this.baseChars = baseSeq.baseChars;
        this.startOffset = this.base.startOffset + start;
        this.endOffset = this.base.startOffset + end;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        if (index >= 0 || index <= this.endOffset - this.startOffset) {
            return this.startOffset + index;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 || index < this.endOffset - this.startOffset) {
            return this.baseChars[index + this.startOffset];
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public CharSubSequence subSequence(Range range) {
        return this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public CharSubSequence subSequence(int start) {
        return this.subSequence(start, this.length());
    }

    @Override
    public CharSubSequence subSequence(int start, int end) {
        if (start >= 0 && end <= this.endOffset - this.startOffset) {
            return this.base.baseSubSequence(this.startOffset + start, this.startOffset + end);
        }
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public CharSubSequence baseSubSequence(int start, int end) {
        if (start >= 0 && end <= this.baseChars.length) {
            return start == this.startOffset && end == this.endOffset ? this : (this.base != this ? this.base.baseSubSequence(start, end) : new CharSubSequence(this.base, start, end));
        }
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public BasedSequence appendTo(StringBuilder out, int start, int end) {
        out.append(this.baseChars, this.startOffset + start, end - start);
        return this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    @Override
    public String toString() {
        return String.valueOf(this.baseChars, this.startOffset, this.endOffset - this.startOffset);
    }

    public static CharSubSequence of(CharSequence charSequence) {
        return CharSubSequence.of(charSequence, 0, charSequence.length());
    }

    public static CharSubSequence of(CharSequence charSequence, int start) {
        return CharSubSequence.of(charSequence, start, charSequence.length());
    }

    public static CharSubSequence of(char[] chars, int start, int end) {
        char[] useChars = new char[chars.length];
        System.arraycopy(chars, 0, useChars, 0, chars.length);
        return start == 0 && end == chars.length ? new CharSubSequence(useChars) : new CharSubSequence(useChars).subSequence(start, end);
    }

    public static CharSubSequence of(CharSequence charSequence, int start, int end) {
        if (start == 0 && end == charSequence.length()) {
            if (charSequence instanceof CharSubSequence) {
                return (CharSubSequence)charSequence;
            }
            if (charSequence instanceof String) {
                return new CharSubSequence(((String)charSequence).toCharArray());
            }
            if (charSequence instanceof StringBuilder) {
                char[] chars = new char[charSequence.length()];
                ((StringBuilder)charSequence).getChars(0, charSequence.length(), chars, 0);
                return new CharSubSequence(chars);
            }
            return new CharSubSequence(charSequence.toString().toCharArray());
        }
        if (charSequence instanceof CharSubSequence) {
            return ((CharSubSequence)charSequence).subSequence(start, end);
        }
        if (charSequence instanceof String) {
            return new CharSubSequence(((String)charSequence).toCharArray()).subSequence(start, end);
        }
        if (charSequence instanceof StringBuilder) {
            char[] chars = new char[charSequence.length()];
            ((StringBuilder)charSequence).getChars(0, charSequence.length(), chars, 0);
            return new CharSubSequence(chars).subSequence(start, end);
        }
        return new CharSubSequence(charSequence.toString().toCharArray()).subSequence(start, end);
    }
}

