/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextRegion;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;

public class ReplacedTextMapper {
    private final BasedSequence original;
    private ArrayList<ReplacedTextRegion> regions = new ArrayList();
    private ArrayList<BasedSequence> replacedSegments = new ArrayList();
    private int replacedLength = 0;

    public ReplacedTextMapper(BasedSequence original) {
        this.original = original;
    }

    public void addReplacedText(BasedSequence originalSegment, BasedSequence replacedSequence) {
        this.regions.add(new ReplacedTextRegion(originalSegment.getSourceRange(), new Range(this.replacedLength, this.replacedLength + replacedSequence.length())));
        this.replacedLength += replacedSequence.length();
        this.replacedSegments.add(replacedSequence);
    }

    public void addOriginalText(BasedSequence originalSegment) {
        if (originalSegment.length() > 0) {
            this.regions.add(new ReplacedTextRegion(originalSegment.getSourceRange(), new Range(this.replacedLength, this.replacedLength + originalSegment.length())));
            this.replacedLength += originalSegment.length();
            this.replacedSegments.add(originalSegment);
        }
    }

    public ArrayList<ReplacedTextRegion> getRegions() {
        return this.regions;
    }

    public ArrayList<BasedSequence> getReplacedSegments() {
        return this.replacedSegments;
    }

    public BasedSequence getReplacedSequence() {
        return SegmentedSequence.of(this.replacedSegments, this.original.subSequence(0, 0));
    }

    public int getReplacedLength() {
        return this.replacedLength;
    }

    public int originalOffset(int replacedIndex) {
        if (this.regions.isEmpty()) {
            return replacedIndex;
        }
        if (replacedIndex == this.replacedLength) {
            return this.original.length();
        }
        int originalIndex = replacedIndex;
        for (ReplacedTextRegion region : this.regions) {
            if (!region.containsReplacedIndex(replacedIndex)) continue;
            originalIndex = region.getOriginalRange().getStart() + replacedIndex - region.getReplacedRange().getStart();
            if (originalIndex > region.getOriginalRange().getEnd()) {
                originalIndex = region.getOriginalRange().getEnd();
            }
            originalIndex -= this.original.getStartOffset();
            break;
        }
        return originalIndex;
    }
}

