/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.FormattingAppendableImpl;
import com.vladsch.flexmark.util.html.HtmlFormattingAppendable;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.io.IOException;

public class HtmlFormattingAppendableBase<T extends HtmlFormattingAppendableBase>
implements HtmlFormattingAppendable {
    private final FormattingAppendable out;
    private Attributes currentAttributes;
    private boolean indentIndentingChildren = false;
    private boolean lineOnChildText = false;
    private boolean withAttributes = false;
    private boolean suppressOpenTagLine = false;
    private boolean suppressCloseTagLine = false;

    public HtmlFormattingAppendableBase(Appendable out) {
        this(out, 0, false);
    }

    public HtmlFormattingAppendableBase(FormattingAppendable other, Appendable out, boolean inheritIndent) {
        this(out, inheritIndent ? other.getIndentPrefix().length() : 0, false);
    }

    public HtmlFormattingAppendableBase(Appendable out, int indentSize, boolean allFormatOptions) {
        this.out = new FormattingAppendableImpl(out, allFormatOptions);
        this.out.setIndentPrefix(RepeatedCharSequence.of(" ", indentSize).toString());
    }

    public HtmlFormattingAppendableBase(Appendable out, int indentSize, int formatOptions) {
        this.out = new FormattingAppendableImpl(out, formatOptions);
        this.out.setIndentPrefix(RepeatedCharSequence.of(" ", indentSize).toString());
    }

    public boolean isSuppressOpenTagLine() {
        return this.suppressOpenTagLine;
    }

    public void setSuppressOpenTagLine(boolean suppressOpenTagLine) {
        this.suppressOpenTagLine = suppressOpenTagLine;
    }

    public boolean isSuppressCloseTagLine() {
        return this.suppressCloseTagLine;
    }

    public T setSuppressCloseTagLine(boolean suppressCloseTagLine) {
        this.suppressCloseTagLine = suppressCloseTagLine;
        return (T)this;
    }

    public T openPre() {
        this.out.openPreFormatted(true);
        return (T)this;
    }

    public T closePre() {
        this.out.closePreFormatted();
        return (T)this;
    }

    @Override
    public boolean inPre() {
        return this.out.isPreFormatted();
    }

    private boolean haveOptions(int options) {
        return (this.out.getOptions() & options) != 0;
    }

    public T raw(CharSequence s) {
        this.out.append(s);
        return (T)this;
    }

    public T raw(CharSequence s, int count) {
        int i = count;
        while (i-- > 0) {
            this.out.append(s);
        }
        return (T)this;
    }

    public T rawPre(CharSequence s) {
        this.out.openPreFormatted(true).append(s).closePreFormatted();
        return (T)this;
    }

    public T rawIndentedPre(CharSequence s) {
        CharSequence prefix = this.out.getPrefix();
        this.out.setPrefix(this.out.getTotalIndentPrefix());
        this.out.openPreFormatted(false).append(s).closePreFormatted();
        this.out.setPrefix(prefix);
        return (T)this;
    }

    public T text(CharSequence s) {
        this.out.append(Escaping.escapeHtml(s, false));
        return (T)this;
    }

    public T attr(CharSequence attrName, CharSequence value) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        this.currentAttributes.replaceValue(attrName, value);
        return (T)this;
    }

    public T attr(Attribute ... attribute) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new Attributes();
        }
        for (Attribute attr : attribute) {
            this.currentAttributes.addValue(attr.getName(), attr.getValue());
        }
        return (T)this;
    }

    public T attr(Attributes attributes) {
        if (!attributes.isEmpty()) {
            if (this.currentAttributes == null) {
                this.currentAttributes = new Attributes(attributes);
            } else {
                this.currentAttributes.addValues(attributes);
            }
        }
        return (T)this;
    }

    public T withAttr() {
        this.withAttributes = true;
        return (T)this;
    }

    @Override
    public Attributes getAttributes() {
        return this.currentAttributes;
    }

    public T setAttributes(Attributes attributes) {
        this.currentAttributes = attributes;
        return (T)this;
    }

    public T withCondLine() {
        this.lineOnChildText = true;
        return (T)this;
    }

    public T withCondIndent() {
        this.indentIndentingChildren = true;
        return (T)this;
    }

    public T tag(CharSequence tagName) {
        return (T)this.tag(tagName, false);
    }

    public T tagVoid(CharSequence tagName) {
        return (T)this.tag(tagName, true);
    }

    protected void tagOpened(CharSequence tagName) {
    }

    protected void tagClosed(CharSequence tagName) {
    }

    public T tag(CharSequence tagName, boolean voidElement) {
        if (tagName.length() == 0 || tagName.charAt(0) == '/') {
            return (T)this.closeTag(tagName);
        }
        Attributes attributes = null;
        if (this.withAttributes) {
            attributes = this.currentAttributes;
            this.currentAttributes = null;
            this.withAttributes = false;
        }
        this.out.append("<");
        this.out.append(tagName);
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes.values()) {
                String attributeValue = attribute.getValue();
                if (attribute.isNonRendering()) continue;
                this.out.append(" ");
                this.out.append(Escaping.escapeHtml(attribute.getName(), true));
                this.out.append("=\"");
                this.out.append(Escaping.escapeHtml(attributeValue, true));
                this.out.append("\"");
            }
        }
        if (voidElement) {
            this.out.append(" />");
        } else {
            this.out.append(">");
            this.tagOpened(tagName);
        }
        return (T)this;
    }

    public T closeTag(CharSequence tagName) {
        if (tagName.length() == 0) {
            throw new IllegalStateException("closeTag called with tag:'" + tagName + "'");
        }
        if (tagName.charAt(0) == '/') {
            this.out.append("<").append(tagName).append(">");
            this.tagClosed(tagName.subSequence(1, tagName.length()));
        } else {
            this.out.append("</").append(tagName).append(">");
            this.tagClosed(tagName);
        }
        return (T)this;
    }

    public T tag(CharSequence tagName, boolean withIndent, boolean withLine, Runnable runnable) {
        if (withIndent && !this.suppressOpenTagLine) {
            this.out.willIndent();
            this.out.line();
        }
        this.tag(tagName, false);
        if (withIndent) {
            this.out.indent();
        }
        final boolean isLineOnChildText = this.lineOnChildText;
        final boolean isIndentIndentingChildren = this.indentIndentingChildren;
        this.lineOnChildText = false;
        this.indentIndentingChildren = false;
        if (isLineOnChildText || isIndentIndentingChildren) {
            this.out.openConditional(new ConditionalFormatter(){

                @Override
                public void apply(boolean firstAppend, boolean onIndent, boolean onLine, boolean onText) {
                    if (onIndent) {
                        if (isIndentIndentingChildren) {
                            HtmlFormattingAppendableBase.this.out.indent();
                        } else {
                            HtmlFormattingAppendableBase.this.out.line();
                        }
                    } else if (firstAppend) {
                        if (isLineOnChildText) {
                            HtmlFormattingAppendableBase.this.out.line();
                        } else if (onLine) {
                            HtmlFormattingAppendableBase.this.out.line();
                        }
                    }
                }
            });
        }
        runnable.run();
        if (isLineOnChildText || isIndentIndentingChildren) {
            this.out.closeConditional(new ConditionalFormatter(){

                @Override
                public void apply(boolean firstAppend, boolean onIndent, boolean onLine, boolean onText) {
                    if (onIndent) {
                        if (isIndentIndentingChildren) {
                            HtmlFormattingAppendableBase.this.out.unIndent();
                        }
                    } else if (onText && isLineOnChildText) {
                        HtmlFormattingAppendableBase.this.out.line();
                    }
                }
            });
        }
        if (withIndent) {
            this.out.unIndent();
        }
        if (withLine && !this.suppressCloseTagLine) {
            this.out.line();
        }
        this.closeTag(tagName);
        if (withIndent && !this.suppressCloseTagLine) {
            this.line();
        }
        return (T)this;
    }

    public T tagVoidLine(CharSequence tagName) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tagVoid(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName, boolean voidElement) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, voidElement)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagLine(CharSequence tagName, Runnable runnable) {
        ((HtmlFormattingAppendableBase)((HtmlFormattingAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, false, false, runnable)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    public T tagIndent(CharSequence tagName, Runnable runnable) {
        this.tag(tagName, true, false, runnable);
        return (T)this;
    }

    public T tagLineIndent(CharSequence tagName, Runnable runnable) {
        this.tag(tagName, true, true, runnable);
        return (T)this;
    }

    @Override
    public Appendable getAppendable() {
        return this.out.getAppendable();
    }

    @Override
    public int getOptions() {
        return this.out.getOptions();
    }

    public T setOptions(int options) {
        this.out.setOptions(options);
        return (T)this;
    }

    @Override
    public int getModCount() {
        return this.out.getModCount();
    }

    @Override
    public boolean isPreFormatted() {
        return this.out.isPreFormatted();
    }

    public T line() {
        this.out.line();
        return (T)this;
    }

    public T addLine() {
        this.out.addLine();
        return (T)this;
    }

    @Override
    public int getPushedPrefixCount() {
        return this.out.getPushedPrefixCount();
    }

    public T blankLine() {
        this.out.blankLine();
        return (T)this;
    }

    public T blankLine(int count) {
        this.out.blankLine(count);
        return (T)this;
    }

    public T blankLineIf(boolean predicate) {
        this.out.blankLineIf(predicate);
        return (T)this;
    }

    public T lineIf(boolean predicate) {
        this.out.lineIf(predicate);
        return (T)this;
    }

    public T indent() {
        this.out.indent();
        return (T)this;
    }

    public T willIndent() {
        this.out.willIndent();
        return (T)this;
    }

    public T unIndent() {
        this.out.unIndent();
        return (T)this;
    }

    @Override
    public IOException getIOException() {
        return this.out.getIOException();
    }

    public T append(CharSequence csq) {
        this.out.append(csq);
        return (T)this;
    }

    public T append(CharSequence csq, int start, int end) {
        this.out.append(csq, start, end);
        return (T)this;
    }

    public T append(char c) {
        this.out.append(c);
        return (T)this;
    }

    @Override
    public String getText() {
        return this.out.getText();
    }

    @Override
    public String getText(int maxBlankLines) {
        return this.out.getText(maxBlankLines);
    }

    public T flush() {
        this.out.flush();
        return (T)this;
    }

    public T flushWhitespaces() {
        this.out.flush();
        return (T)this;
    }

    public T flush(int maxBlankLines) {
        this.out.flush(maxBlankLines);
        return (T)this;
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.out.getIndentPrefix();
    }

    public T setIndentPrefix(CharSequence prefix) {
        this.out.setIndentPrefix(prefix);
        return (T)this;
    }

    @Override
    public CharSequence getPrefix() {
        return this.out.getPrefix();
    }

    public T setPrefix(CharSequence prefix) {
        this.out.setPrefix(prefix);
        return (T)this;
    }

    public T addPrefix(CharSequence prefix) {
        this.out.addPrefix(prefix);
        return (T)this;
    }

    public T pushPrefix() {
        this.out.pushPrefix();
        return (T)this;
    }

    public T popPrefix() {
        this.out.popPrefix();
        return (T)this;
    }

    public T addAfterEolRunnable(int atPendingEOL, Runnable runnable) {
        this.out.addAfterEolRunnable(atPendingEOL, runnable);
        return (T)this;
    }

    @Override
    public CharSequence getTotalIndentPrefix() {
        return this.out.getTotalIndentPrefix();
    }

    public T line(Ref<Boolean> lineRef) {
        this.out.line(lineRef);
        return (T)this;
    }

    public T lineIf(Ref<Boolean> lineRef) {
        this.out.lineIf(lineRef);
        return (T)this;
    }

    public T repeat(char c, int count) {
        this.out.repeat(c, count);
        return (T)this;
    }

    public T repeat(CharSequence csq, int count) {
        this.out.repeat(csq, count);
        return (T)this;
    }

    public T repeat(CharSequence csq, int start, int end, int count) {
        this.out.repeat(csq, start, end, count);
        return (T)this;
    }

    @Override
    public boolean isPendingSpace() {
        return this.out.isPendingSpace();
    }

    @Override
    public boolean isPendingEOL() {
        return this.out.isPendingSpace();
    }

    @Override
    public int getPendingEOL() {
        return this.out.getPendingEOL();
    }

    @Override
    public int getIndent() {
        return this.out.getIndent();
    }

    public T setIndentOffset(int indentOffset) {
        this.out.setIndentOffset(indentOffset);
        return (T)this;
    }

    @Override
    public int getLineCount() {
        return this.out.getLineCount();
    }

    public T lastOffset(Ref<Integer> refOffset) {
        this.out.lastOffset(refOffset);
        return (T)this;
    }

    @Override
    public int lastOffset() {
        return this.out.lastOffset();
    }

    @Override
    public int offset() {
        return this.out.offset();
    }

    public T openPreFormatted(boolean keepIndent) {
        this.out.openPreFormatted(true);
        return (T)this;
    }

    public T closePreFormatted() {
        this.out.closePreFormatted();
        return (T)this;
    }

    public T openConditional(ConditionalFormatter openFormatter) {
        this.out.openConditional(openFormatter);
        return (T)this;
    }

    public T closeConditional(ConditionalFormatter closeFormatter) {
        this.out.closeConditional(closeFormatter);
        return (T)this;
    }
}

